/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.gui;

import earth.terrarium.pastel.PastelCommon;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public interface PastelTooltipComponent
extends ClientTooltipComponent {
    public static final ResourceLocation TEXTURE = PastelCommon.locate("textures/gui/container/pastel_tooltips.png");

    public static void drawOutline(GuiGraphics context, int x, int y, int columns, int rows) {
        int j;
        PastelTooltipComponent.draw(context, x, y, Sprite.BORDER_CORNER_TOP);
        PastelTooltipComponent.draw(context, x + columns * 18 + 1, y, Sprite.BORDER_CORNER_TOP);
        for (j = 0; j < columns; ++j) {
            PastelTooltipComponent.draw(context, x + 1 + j * 18, y, Sprite.BORDER_HORIZONTAL_TOP);
            PastelTooltipComponent.draw(context, x + 1 + j * 18, y + rows * 20, Sprite.BORDER_HORIZONTAL_BOTTOM);
        }
        for (j = 0; j < rows; ++j) {
            PastelTooltipComponent.draw(context, x, y + j * 20 + 1, Sprite.BORDER_VERTICAL);
            PastelTooltipComponent.draw(context, x + columns * 18 + 1, y + j * 20 + 1, Sprite.BORDER_VERTICAL);
        }
        PastelTooltipComponent.draw(context, x, y + rows * 20, Sprite.BORDER_CORNER_BOTTOM);
        PastelTooltipComponent.draw(context, x + columns * 18 + 1, y + rows * 20, Sprite.BORDER_CORNER_BOTTOM);
    }

    public static void drawSlot(GuiGraphics context, int x, int y, int index, ItemStack itemStack, Font textRenderer) {
        PastelTooltipComponent.draw(context, x, y, Sprite.SLOT);
        context.renderItem(itemStack, x + 1, y + 1, index);
        context.renderItemDecorations(textRenderer, itemStack, x + 1, y + 1);
        if (index == 0) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)context, (int)(x + 1), (int)(y + 1), (int)0);
        }
    }

    public static void drawDottedSlot(GuiGraphics context, int x, int y) {
        PastelTooltipComponent.draw(context, x, y, Sprite.DOTTED_SLOT);
    }

    private static void draw(GuiGraphics context, int x, int y, @NotNull Sprite sprite) {
        context.blit(TEXTURE, x, y, (float)sprite.u, (float)sprite.v, sprite.width, sprite.height, 128, 128);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Sprite {
        SLOT(0, 0, 18, 20),
        DOTTED_SLOT(18, 0, 36, 20),
        BLOCKED_SLOT(0, 40, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int u;
        public final int v;
        public final int width;
        public final int height;

        private Sprite(int u, int v, int width, int height) {
            this.u = u;
            this.v = v;
            this.width = width;
            this.height = height;
        }
    }
}

