/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.energy;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import org.jetbrains.annotations.NotNull;

public interface InkStorage
extends Clearable {
    public static long transferInk(@NotNull InkStorage source, @NotNull InkStorage destination) {
        long transferred = 0L;
        for (InkColor inkColor : source.getEnergy().keySet()) {
            transferred += InkStorage.transferInk(source, destination, inkColor);
        }
        return transferred;
    }

    public static long transferInk(@NotNull InkStorage source, @NotNull InkStorage destination, @NotNull InkColor color) {
        long destinationAmount;
        long destinationRoom;
        if (!destination.accepts(color)) {
            return 0L;
        }
        long sourceAmount = source.getEnergy(color);
        if (sourceAmount > 0L && (destinationRoom = destination.getRoom(color)) > 0L && sourceAmount > (destinationAmount = destination.getEnergy(color)) + 1L) {
            long transferAmount = Math.max(1L, (sourceAmount - destinationAmount) / 32L);
            transferAmount = Math.min(transferAmount, Math.min(sourceAmount, destinationRoom));
            destination.addEnergy(color, transferAmount);
            source.drainEnergy(color, transferAmount);
            return transferAmount;
        }
        return 0L;
    }

    @Deprecated
    public static long transferInk(@NotNull InkStorage source, @NotNull InkStorage destination, @NotNull InkColor color, long amount) {
        long transferAmount;
        long destinationRoom;
        if (!destination.accepts(color)) {
            return 0L;
        }
        long sourceAmount = source.getEnergy(color);
        if (sourceAmount > 0L && (destinationRoom = destination.getRoom(color)) > 0L && (transferAmount = Math.min(amount, Math.min(sourceAmount, destinationRoom))) > 0L) {
            destination.addEnergy(color, transferAmount);
            source.drainEnergy(color, transferAmount);
            return transferAmount;
        }
        return 0L;
    }

    public boolean accepts(InkColor var1);

    public long addEnergy(InkColor var1, long var2);

    public long drainEnergy(InkColor var1, long var2);

    public boolean requestEnergy(InkColor var1, long var2);

    public long getEnergy(InkColor var1);

    @Deprecated
    public Map<InkColor, Long> getEnergy();

    @Deprecated
    public void setEnergy(Map<InkColor, Long> var1, long var2);

    public long getMaxPerColor();

    public long getMaxTotal();

    public long getCurrentTotal();

    public boolean isEmpty();

    public boolean isFull();

    public void fillCompletely();

    public void clearContent();

    default public float getFillPercent(InkColor color) {
        return Mth.clamp((float)((float)this.getEnergy(color) / (float)this.getMaxPerColor()), (float)0.0f, (float)1.0f);
    }

    default public float getTotalFillPercent() {
        return Mth.clamp((float)((float)this.getCurrentTotal() / (float)this.getMaxTotal()), (float)0.0f, (float)1.0f);
    }

    public void addTooltip(List<Component> var1);

    public long getRoom(InkColor var1);

    @NotNull
    public static Map<InkColor, Long> readEnergy(CompoundTag compound) {
        HashMap<InkColor, Long> energy = new HashMap<InkColor, Long>();
        if (compound != null) {
            for (String key : compound.getAllKeys()) {
                InkColor inkColor = (InkColor)PastelRegistries.INK_COLOR.get(PastelCommon.locate(key));
                if (inkColor == null) continue;
                long amount = compound.getLong(key);
                energy.put(inkColor, amount);
            }
        }
        return energy;
    }

    @NotNull
    public static CompoundTag writeEnergy(Map<InkColor, Long> storedEnergy) {
        CompoundTag energy = new CompoundTag();
        for (Map.Entry<InkColor, Long> color : storedEnergy.entrySet()) {
            energy.putLong(color.getKey().getID().toString(), color.getValue().longValue());
        }
        return energy;
    }

    public static void addInkStoreBulletTooltip(List<Component> tooltip, InkColor color, long amount) {
        MutableComponent inkName = color.getColoredInkName();
        tooltip.add((Component)Component.translatable((String)"pastel.tooltip.ink_powered.bullet_amount", (Object[])new Object[]{Component.literal((String)Support.getShortenedNumberString(amount)).withStyle(ChatFormatting.WHITE), inkName}).setStyle(inkName.getStyle()));
    }
}

