/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.energy;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.components.InkPoweredComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelMobEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class InkPoweredStatusEffectInstance {
    public static final Codec<InkPoweredStatusEffectInstance> CODEC = RecordCodecBuilder.create(i -> i.group((App)MobEffectInstance.CODEC.fieldOf("effect").forGetter(c -> c.statusEffectInstance), (App)InkCost.CODEC.fieldOf("ink_cost").forGetter(c -> c.cost), (App)Codec.INT.optionalFieldOf("custom_color", (Object)-1).forGetter(c -> c.customColor), (App)Codec.BOOL.optionalFieldOf("unidentifiable", (Object)false).forGetter(c -> c.unidentifiable), (App)Codec.BOOL.optionalFieldOf("incurable", (Object)false).forGetter(c -> c.incurable)).apply((Applicative)i, InkPoweredStatusEffectInstance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, InkPoweredStatusEffectInstance> STREAM_CODEC = StreamCodec.composite((StreamCodec)MobEffectInstance.STREAM_CODEC, c -> c.statusEffectInstance, InkCost.STREAM_CODEC, c -> c.cost, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.customColor, (StreamCodec)ByteBufCodecs.BOOL, c -> c.unidentifiable, (StreamCodec)ByteBufCodecs.BOOL, c -> c.incurable, InkPoweredStatusEffectInstance::new);
    public static final String NBT_KEY = "InkPoweredStatusEffects";
    private final MobEffectInstance statusEffectInstance;
    private final InkCost cost;
    private final int customColor;
    private final boolean unidentifiable;
    private final boolean incurable;

    public InkPoweredStatusEffectInstance(MobEffectInstance statusEffectInstance, InkCost cost, int customColor, boolean unidentifiable, boolean incurable) {
        this.statusEffectInstance = statusEffectInstance;
        this.cost = cost;
        this.customColor = customColor;
        this.unidentifiable = unidentifiable;
        this.incurable = incurable;
        if (incurable) {
            statusEffectInstance.getCures().add(PastelMobEffects.Cures.INCURABLE);
        }
    }

    public MobEffectInstance getStatusEffectInstance() {
        return this.statusEffectInstance;
    }

    public InkCost getInkCost() {
        return this.cost;
    }

    public static List<InkPoweredStatusEffectInstance> getEffects(ItemStack stack) {
        return ((InkPoweredComponent)stack.getOrDefault(PastelDataComponentTypes.INK_POWERED, (Object)InkPoweredComponent.DEFAULT)).effects();
    }

    public static void setEffects(ItemStack stack, List<InkPoweredStatusEffectInstance> effects) {
        stack.set(PastelDataComponentTypes.INK_POWERED, (Object)new InkPoweredComponent(effects));
    }

    public static void buildTooltip(List<Component> tooltip, List<InkPoweredStatusEffectInstance> effects, MutableComponent attributeModifierText, boolean showDuration, float tickRate) {
        if (!effects.isEmpty()) {
            ArrayList attributeModifiers = Lists.newArrayList();
            for (InkPoweredStatusEffectInstance entry : effects) {
                if (entry.isUnidentifiable()) {
                    tooltip.add((Component)Component.translatable((String)"item.pastel.potion.tooltip.unidentifiable"));
                    continue;
                }
                MobEffectInstance effect = entry.getStatusEffectInstance();
                if (effect == null) continue;
                InkCost cost = entry.getInkCost();
                if (effect == null) {
                    tooltip.add((Component)Component.translatable((String)"item.pastel.potion.tooltip.invalid"));
                    continue;
                }
                MutableComponent mutableText = Component.translatable((String)effect.getDescriptionId());
                if (effect.getAmplifier() > 0) {
                    mutableText = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, Component.translatable((String)("potion.potency." + effect.getAmplifier()))});
                }
                if (showDuration && effect.getDuration() > 20) {
                    mutableText = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableText, MobEffectUtil.formatDuration((MobEffectInstance)effect, (float)1.0f, (float)tickRate)});
                }
                mutableText.withStyle(((MobEffect)effect.getEffect().value()).getCategory().getTooltipFormatting());
                mutableText.append((Component)Component.translatable((String)"pastel.tooltip.ink_cost", (Object[])new Object[]{Support.getShortenedNumberString(cost.cost()), cost.color().getColoredInkName()}).withStyle(ChatFormatting.GRAY));
                if (entry.isIncurable()) {
                    mutableText.append((Component)Component.translatable((String)"item.pastel.potion.tooltip.incurable"));
                }
                tooltip.add((Component)mutableText);
                ((MobEffect)effect.getEffect().value()).createModifiers(effect.getAmplifier(), (attribute, modifier) -> attributeModifiers.add(new Tuple(attribute, modifier)));
            }
            if (!attributeModifiers.isEmpty()) {
                tooltip.add((Component)Component.empty());
                tooltip.add((Component)attributeModifierText.withStyle(ChatFormatting.DARK_PURPLE));
                for (Tuple pair : attributeModifiers) {
                    MutableComponent translatedAttribute = Component.translatable((String)((Attribute)((Holder)pair.getA()).value()).getDescriptionId());
                    AttributeModifier mutableText = (AttributeModifier)pair.getB();
                    double statusEffect = mutableText.amount();
                    double d = mutableText.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && mutableText.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? mutableText.amount() : mutableText.amount() * 100.0;
                    if (statusEffect > 0.0) {
                        tooltip.add((Component)Component.translatable((String)("attribute.modifier.plus." + mutableText.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d), translatedAttribute}).withStyle(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(statusEffect < 0.0)) continue;
                    tooltip.add((Component)Component.translatable((String)("attribute.modifier.take." + mutableText.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d *= -1.0), translatedAttribute}).withStyle(ChatFormatting.RED));
                }
            }
        }
    }

    public int getColor() {
        if (this.customColor == -1) {
            return ((MobEffect)this.statusEffectInstance.getEffect().value()).getColor();
        }
        return this.customColor;
    }

    public boolean isUnidentifiable() {
        return this.unidentifiable;
    }

    public boolean isIncurable() {
        return this.incurable;
    }
}

