/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.color;

import earth.terrarium.pastel.api.color.ColorRegistry;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidColors
extends ColorRegistry<Fluid> {
    private static final HashMap<Fluid, InkColor> COLORS = new HashMap<Fluid, InkColor>(){
        {
            this.put(Fluids.WATER, InkColors.BLUE);
            this.put(Fluids.LAVA, InkColors.ORANGE);
        }
    };

    @Override
    public void registerColorMapping(Fluid fluid, InkColor color) {
        COLORS.put(fluid, color);
    }

    @Override
    public Optional<InkColor> getMapping(Fluid fluid) {
        if (COLORS.containsKey(fluid)) {
            return Optional.of(COLORS.get(fluid));
        }
        return Optional.empty();
    }

    @Override
    public InkColor getMapping(Fluid fluid, InkColor fallback) {
        return COLORS.getOrDefault(fluid, fallback);
    }
}

