/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface StrippableDrop {
    public Block getStrippedBlock();

    public ResourceKey<LootTable> getStrippingLootTableKey();

    default public boolean checkAndDropStrippedLoot(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!moved && newState.is(this.getStrippedBlock())) {
            List<ItemStack> harvestedStacks = StrippableDrop.getStrippedStacks(state, (ServerLevel)world, pos, world.getBlockEntity(pos), null, ItemStack.EMPTY, this.getStrippingLootTableKey());
            for (ItemStack harvestedStack : harvestedStacks) {
                Containers.dropItemStack((Level)world, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)harvestedStack);
            }
            return true;
        }
        return false;
    }

    public static List<ItemStack> getStrippedStacks(BlockState state, ServerLevel world, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, ItemStack stack, ResourceKey<LootTable> lootTableKey) {
        LootParams.Builder builder = new LootParams.Builder(world).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)stack).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)entity).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
        LootTable lootTable = world.getServer().reloadableRegistries().getLootTable(lootTableKey);
        return lootTable.getRandomItems(builder.create(LootContextParamSets.BLOCK));
    }
}

