/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.block;

import earth.terrarium.pastel.helpers.data.ColorHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface ColorableBlock {
    public boolean color(Level var1, BlockPos var2, Optional<DyeColor> var3, @Nullable Entity var4);

    public Optional<DyeColor> getColor(Level var1, BlockPos var2);

    default public boolean isColor(Level world, BlockPos pos, Optional<DyeColor> color) {
        return this.getColor(world, pos) == color;
    }

    default public boolean tryColorUsingStackInHand(ItemStack handStack, Level world, BlockPos pos, Player player, InteractionHand hand) {
        Optional<DyeColor> itemInHandColor = ColorHelper.getDyeColorOfItemStack(handStack);
        if (itemInHandColor.isPresent() && this.color(world, pos, itemInHandColor, (Entity)player)) {
            if (!player.isCreative()) {
                handStack.shrink(1);
            }
            return true;
        }
        return false;
    }
}

