/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.fakelevel;

import com.ldtteam.common.fakelevel.FakeLevel;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class FakeLevelLightEngine
extends LevelLightEngine {
    private final FakeLevel<?> fakeLevel;
    private FakeLevelLayerLightEventListener blockLightLayer = null;
    private FakeLevelLayerLightEventListener skyLightLayer = null;

    public FakeLevelLightEngine(final FakeLevel<?> level) {
        super(new LightChunkGetter(){

            public LightChunk getChunkForLighting(int p_63023_, int p_63024_) {
                throw new UnsupportedOperationException("Should never happen - FakeLevel light engine ctor");
            }

            public BlockGetter getLevel() {
                return level;
            }
        }, false, false);
        this.fakeLevel = level;
    }

    public int getRawBrightness(BlockPos p_75832_, int p_75833_) {
        return this.fakeLevel.getRawBrightness(p_75832_, p_75833_);
    }

    public String getDebugData(LightLayer p_75817_, SectionPos p_75818_) {
        return "FakeLevel light engine redirect - " + String.valueOf(p_75817_);
    }

    public LayerLightEventListener getLayerListener(LightLayer p_75815_) {
        return switch (p_75815_) {
            default -> throw new MatchException(null, null);
            case LightLayer.BLOCK -> {
                if (this.blockLightLayer == null) {
                    this.blockLightLayer = new FakeLevelLayerLightEventListener(p_75815_);
                }
                yield this.blockLightLayer;
            }
            case LightLayer.SKY -> {
                if (this.skyLightLayer == null) {
                    this.skyLightLayer = new FakeLevelLayerLightEventListener(p_75815_);
                }
                yield this.skyLightLayer;
            }
        };
    }

    public LayerLightSectionStorage.SectionType getDebugSectionType(LightLayer p_285008_, SectionPos p_285336_) {
        return LayerLightSectionStorage.SectionType.EMPTY;
    }

    public boolean lightOnInSection(SectionPos p_285319_) {
        return false;
    }

    public void checkBlock(BlockPos p_75823_) {
    }

    public boolean hasLightWork() {
        return false;
    }

    public void propagateLightSources(ChunkPos p_284998_) {
    }

    public void queueSectionData(LightLayer p_285328_, SectionPos p_284962_, DataLayer p_285035_) {
    }

    public void retainData(ChunkPos p_75829_, boolean p_75830_) {
    }

    public int runLightUpdates() {
        return 0;
    }

    public void setLightEnabled(ChunkPos p_285439_, boolean p_285012_) {
    }

    public void updateSectionStatus(SectionPos p_75827_, boolean p_75828_) {
    }

    public void updateSectionStatus(BlockPos p_75835_, boolean p_75836_) {
    }

    private class FakeLevelLayerLightEventListener
    implements LayerLightEventListener {
        private final LightLayer lightLayer;

        private FakeLevelLayerLightEventListener(LightLayer lightLayer) {
            this.lightLayer = lightLayer;
        }

        public void checkBlock(BlockPos p_164454_) {
        }

        public boolean hasLightWork() {
            return false;
        }

        public int runLightUpdates() {
            return 0;
        }

        public void updateSectionStatus(SectionPos p_75837_, boolean p_75838_) {
        }

        public void setLightEnabled(ChunkPos p_164452_, boolean p_164453_) {
        }

        public void propagateLightSources(ChunkPos p_285263_) {
        }

        @Nullable
        public DataLayer getDataLayerData(SectionPos p_75709_) {
            return null;
        }

        public int getLightValue(BlockPos p_75710_) {
            return FakeLevelLightEngine.this.fakeLevel.getBrightness(this.lightLayer, p_75710_);
        }
    }
}

