/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.cursor;

import com.ldtteam.blockui.util.texture.CursorTexture;
import com.ldtteam.blockui.util.texture.IsOurTexture;
import com.ldtteam.blockui.util.texture.MissingCursorTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLEnvironment;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorUtils.class);
    private static final long[] STANDARD_CURSORS = new long[StandardCursor.values().length];
    private static long lastCursorAddress = 0L;

    public static CursorTexture setCursorImage(ResourceLocation rl) {
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(rl);
        if (texture == MissingTextureAtlasSprite.getTexture()) {
            texture = MissingCursorTexture.INSTANCE;
        }
        if (!(texture instanceof CursorTexture)) {
            throw new IllegalArgumentException("Did you forget to load CursorTexture for: " + String.valueOf(rl));
        }
        CursorTexture cursorTexture = (CursorTexture)texture;
        cursorTexture.setCursor();
        return cursorTexture;
    }

    public static void loadCursorTexture(ResourceLocation resLoc) {
        TextureManager texManager = Minecraft.getInstance().getTextureManager();
        AbstractTexture texture = texManager.getTexture(resLoc, null);
        if (!(texture instanceof CursorTexture)) {
            if (IsOurTexture.isOur(texture)) {
                LOGGER.warn("Trying to use special BlockUI texture as cursor? Things may not work well: " + resLoc.toString());
            }
            texManager.register(resLoc, (AbstractTexture)new CursorTexture(resLoc));
            if (!FMLEnvironment.production && texManager.getTexture(resLoc) == MissingTextureAtlasSprite.getTexture() && !resLoc.getNamespace().equals("blockui")) {
                throw new IllegalArgumentException("Missing texture: " + String.valueOf(resLoc));
            }
        }
    }

    public static void setStandardCursor(StandardCursor shape) {
        if (shape == StandardCursor.DEFAULT) {
            CursorUtils.resetCursor();
            return;
        }
        int ord = shape.ordinal();
        if (STANDARD_CURSORS[ord] == 0L) {
            RenderSystem.assertOnRenderThread();
            CursorUtils.STANDARD_CURSORS[ord] = GLFW.glfwCreateStandardCursor((int)shape.glfwValue);
            if (STANDARD_CURSORS[ord] == 0L) {
                LOGGER.error("Cannot create standard cursor for shape: " + String.valueOf((Object)shape));
                return;
            }
        }
        CursorUtils.setCursorAddress(STANDARD_CURSORS[ord]);
    }

    public static void resetCursor() {
        CursorUtils.setCursorAddress(0L);
    }

    public static void setCursorAddress(long cursorAddress) {
        RenderSystem.assertOnRenderThread();
        if (cursorAddress != lastCursorAddress) {
            GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)cursorAddress);
            lastCursorAddress = cursorAddress;
        }
    }

    public static boolean isCurrentCursor(long testedAddress) {
        return testedAddress == lastCursorAddress;
    }

    public static enum StandardCursor {
        DEFAULT(Integer.MIN_VALUE),
        ARROW(221185),
        TEXT_CURSOR(221186),
        CROSSHAIR(221187),
        HAND(221188),
        HORIZONTAL_RESIZE(221189),
        VERTICAL_RESIZE(221190),
        RESIZE(221193),
        RESIZE2(221191),
        RESIZE3(221192);

        private final int glfwValue;

        private StandardCursor(int glfwValue) {
            this.glfwValue = glfwValue;
        }
    }
}

