/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class SingleBlockGetter
implements BlockGetter {
    public BlockState blockState = null;
    public BlockEntity blockEntity = null;

    public SingleBlockGetter(BlockState blockState, BlockEntity blockEntity) {
        this.blockState = blockState;
        this.blockEntity = blockEntity;
    }

    public SingleBlockGetter(BlockState blockState) {
        this(blockState, null);
    }

    public SingleBlockGetter() {
        this(null, null);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return BlockPos.ZERO.equals((Object)pos) ? this.blockEntity : null;
    }

    public BlockState getBlockState(BlockPos pos) {
        return BlockPos.ZERO.equals((Object)pos) ? this.blockState : Blocks.VOID_AIR.defaultBlockState();
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    public int getHeight() {
        return 1;
    }

    public int getMinBuildHeight() {
        return 0;
    }

    public static class SingleBlockNeighborhood
    extends SingleBlockGetter
    implements BlockAndTintGetter {
        public SingleBlockNeighborhood(BlockState blockState, BlockEntity blockEntity) {
            super(blockState, blockEntity);
        }

        public SingleBlockNeighborhood(BlockState blockState) {
            super(blockState, null);
        }

        public SingleBlockNeighborhood() {
            super(null, null);
        }

        public float getShade(Direction direction, boolean shade) {
            return 1.0f;
        }

        public LevelLightEngine getLightEngine() {
            throw new UnsupportedOperationException("Does anyone need LightEngine?");
        }

        public int getBlockTint(BlockPos pos, ColorResolver colorResolver) {
            return colorResolver.getColor((Biome)ServerLifecycleHooks.getCurrentServer().registryAccess().registryOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS), (double)pos.getX(), (double)pos.getZ());
        }

        public int getBrightness(LightLayer lightLayer, BlockPos pos) {
            return 10;
        }

        public int getRawBrightness(BlockPos pos, int amount) {
            return 10;
        }
    }
}

