/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.Parsers;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.util.texture.ResolvedWidgetSprites;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.fml.loading.FMLEnvironment;

public class ButtonImage
extends Button {
    public static final WidgetSprites VANILLA_BUTTON = AbstractButton.SPRITES;
    public static final int DEFAULT_BUTTON_WIDTH = 200;
    public static final int DEFAULT_BUTTON_HEIGHT = 20;
    public static final int DEFAULT_ENABLED_COLOR = 0xFFFFFF;
    public static final int DEFAULT_HOVER_COLOR = 0xFFFFA0;
    public static final int DEFAULT_DISABLED_COLOR = 0xA0A0A0;
    protected WidgetSprites textures = VANILLA_BUTTON;
    protected ResolvedWidgetSprites resolvedTextures = null;

    public ButtonImage() {
        this(false);
    }

    public ButtonImage(boolean vanilla) {
        super(Alignment.MIDDLE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
        if (vanilla) {
            this.setVanillaButton();
        }
        this.recalcTextRendering();
    }

    public ButtonImage(PaneParams params) {
        super(params, Alignment.MIDDLE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
        if (params.hasAttribute("source")) {
            ResourceLocation enabled = params.getResource("source", MissingTextureAtlasSprite.getLocation());
            ResourceLocation focused = params.getResource("highlight", enabled);
            ResourceLocation disabled = params.getResource("disabled", enabled);
            this.setTextures(new WidgetSprites(enabled, disabled, focused, disabled));
        } else {
            this.setVanillaButton();
        }
        this.loadTextInfo(params);
    }

    public void setVanillaButton() {
        if (this.width == 0) {
            this.width = 200;
        }
        if (this.height == 0) {
            this.height = 20;
        }
        this.textures = VANILLA_BUTTON;
        this.textColor = 0xFFFFFF;
        this.textHoverColor = 0xFFFFA0;
        this.textDisabledColor = 0xA0A0A0;
        this.textOffsetX = 3;
        this.textOffsetY = 3;
        this.textWidth = this.width - 2 * this.textOffsetX;
        this.textHeight = this.height - 2 * this.textOffsetY;
    }

    private void loadTextInfo(PaneParams params) {
        this.textColor = params.getColor("textcolor", this.textColor);
        this.textHoverColor = params.getColor("texthovercolor", this.textHoverColor);
        this.textDisabledColor = params.getColor("textdisabledcolor", this.textDisabledColor);
        params.applyShorthand("textoffset", Parsers.INT, 2, a -> {
            this.textOffsetX = (Integer)a.get(0);
            this.textOffsetY = (Integer)a.get(1);
        });
        params.applyShorthand("textbox", Parsers.INT, 2, a -> {
            this.textWidth = (Integer)a.get(0);
            this.textHeight = (Integer)a.get(1);
        });
        this.recalcTextRendering();
    }

    public void setTextures(WidgetSprites buttonTextures) {
        this.textures = buttonTextures;
        this.resolvedTextures = null;
    }

    public WidgetSprites getTextures() {
        return this.textures;
    }

    private boolean replacedVanillaButton(ResourceLocation loc) {
        if (this.textures == VANILLA_BUTTON) {
            this.setTextures(new WidgetSprites(loc, loc, loc, loc));
            return true;
        }
        return false;
    }

    public void setImage(ResourceLocation loc) {
        if (!this.replacedVanillaButton(loc) && !Objects.equals(loc, this.textures.enabled())) {
            if (Objects.equals(this.textures.enabled(), this.textures.enabledFocused())) {
                this.setImageHighlight(loc);
            }
            this.setTextures(new WidgetSprites(loc, this.textures.disabled(), this.textures.enabledFocused(), this.textures.disabledFocused()));
        }
    }

    public void setImageHighlight(ResourceLocation loc) {
        if (!this.replacedVanillaButton(loc) && !Objects.equals(loc, this.textures.enabledFocused())) {
            this.setTextures(new WidgetSprites(this.textures.enabled(), this.textures.disabled(), loc, this.textures.disabledFocused()));
        }
    }

    public void setImageDisabled(ResourceLocation loc) {
        if (!this.replacedVanillaButton(loc) && !Objects.equals(loc, this.textures.disabled())) {
            if (Objects.equals(this.textures.disabled(), this.textures.disabledFocused())) {
                this.setImageHighlightDisabled(loc);
            }
            this.setTextures(new WidgetSprites(this.textures.enabled(), loc, this.textures.enabledFocused(), this.textures.disabledFocused()));
        }
    }

    public void setImageHighlightDisabled(ResourceLocation loc) {
        if (!this.replacedVanillaButton(loc) && !Objects.equals(loc, this.textures.disabledFocused())) {
            this.setTextures(new WidgetSprites(this.textures.enabled(), this.textures.disabled(), this.textures.enabledFocused(), loc));
        }
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        if (!FMLEnvironment.production) {
            Objects.requireNonNull(this.textures.enabled(), () -> this.id + " | " + String.valueOf(this.window.getXmlResourceLocation()));
        }
        if (this.resolvedTextures == null) {
            this.resolvedTextures = ResolvedWidgetSprites.fromUnresolved(this.textures, Image::resolveBlit);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.resolvedTextures.getAndPrepare(this.isEnabled(), this.wasCursorInPane).blit(target.pose(), this.x, this.y, this.width, this.height);
        this.postDrawBackground(target, mx, my);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.drawSelf(target, mx, my);
    }

    public void postDrawBackground(BOGuiGraphics target, double mx, double my) {
    }

    @Override
    public void setSize(int w, int h) {
        int newTextWidth = (int)((double)(this.textWidth * w) / (double)this.width);
        int newTextHeight = (int)((double)(this.textHeight * h) / (double)this.height);
        super.setSize(w, h);
        this.textWidth = newTextWidth;
        this.textHeight = newTextHeight;
        this.recalcTextRendering();
    }

    public void setTextOffset(int textOffsetX, int textOffsetY) {
        this.textOffsetX = Mth.clamp((int)textOffsetX, (int)0, (int)this.width);
        this.textOffsetY = Mth.clamp((int)textOffsetY, (int)0, (int)this.height);
    }

    public void setTextRenderBox(int textWidth, int textHeight) {
        this.textWidth = Mth.clamp((int)textWidth, (int)0, (int)(this.width - this.textOffsetX));
        this.textHeight = Mth.clamp((int)textHeight, (int)0, (int)(this.height - this.textOffsetY));
        this.recalcTextRendering();
    }
}

