/*
 * Decompiled with CFR 0.152.
 */
package intothedarkness.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.util.DeferredSoundType;

public class OliveLogBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;

    public OliveLogBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound((SoundType)new DeferredSoundType(1.0f, 1.0f, () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.cherry_wood.break")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.wood.step")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.cherry_wood.place")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.cherry_wood.hit")), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.bamboo_wood.fall")))).strength(1.5f, 2.0f).pushReaction(PushReaction.PUSH_ONLY));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(AXIS, (Comparable)context.getClickedFace().getAxis());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
            if (state.getValue(AXIS) == Direction.Axis.X) {
                return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
            }
            if (state.getValue(AXIS) == Direction.Axis.Z) {
                return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
            }
        }
        return state;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 1;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.WALKABLE;
    }
}

