/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.tiers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.net.WorldTierPayload;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugment;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugmentRegistry;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public enum WorldTier implements StringRepresentable
{
    HAVEN("haven"),
    FRONTIER("frontier"),
    ASCENT("ascent"),
    SUMMIT("summit"),
    PINNACLE("pinnacle");

    public static final IntFunction<WorldTier> BY_ID;
    public static final Codec<WorldTier> CODEC;
    public static final StreamCodec<ByteBuf, WorldTier> STREAM_CODEC;
    private String name;

    private WorldTier(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public ResourceLocation getUnlockAdvancement() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Apoth.Advancements.WORLD_TIER_HAVEN;
            case 1 -> Apoth.Advancements.WORLD_TIER_FRONTIER;
            case 2 -> Apoth.Advancements.WORLD_TIER_ASCENT;
            case 3 -> Apoth.Advancements.WORLD_TIER_SUMMIT;
            case 4 -> Apoth.Advancements.WORLD_TIER_PINNACLE;
        };
    }

    public static WorldTier getTier(Player player) {
        FakePlayer fp;
        MinecraftServer server;
        ServerPlayer realPlayer;
        if (player instanceof FakePlayer && (realPlayer = (server = (fp = (FakePlayer)player).getServer()).getPlayerList().getPlayer(fp.getUUID())) != null) {
            WorldTier realTier = WorldTier.getTier((Player)realPlayer);
            fp.setData(Apoth.Attachments.WORLD_TIER, (Object)realTier);
            return realTier;
        }
        return (WorldTier)((Object)player.getData(Apoth.Attachments.WORLD_TIER));
    }

    public static void setTier(Player player, WorldTier tier) {
        WorldTier oldTier = (WorldTier)((Object)player.getData(Apoth.Attachments.WORLD_TIER));
        if (oldTier == tier && !WorldTier.isTutorialActive(player)) {
            return;
        }
        player.setData(Apoth.Attachments.WORLD_TIER, (Object)tier);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new WorldTierPayload(tier), (CustomPacketPayload[])new CustomPacketPayload[0]);
            for (TierAugment aug : TierAugmentRegistry.getAugments(oldTier, TierAugment.Target.PLAYERS)) {
                aug.remove((ServerLevelAccessor)((ServerLevel)sp.level()), (LivingEntity)player);
            }
            for (TierAugment aug : TierAugmentRegistry.getAugments(tier, TierAugment.Target.PLAYERS)) {
                aug.apply((ServerLevelAccessor)((ServerLevel)sp.level()), (LivingEntity)player);
            }
            player.setData(Apoth.Attachments.TIER_AUGMENTS_APPLIED, (Object)true);
            player.awardStat(Apoth.Stats.WORLD_TIERS_ACTIVATED);
        }
    }

    public static boolean isUnlocked(Player player, WorldTier tier) {
        return ApothMiscUtil.hasAdvancement(player, tier.getUnlockAdvancement());
    }

    public static boolean isTutorialActive(Player player) {
        if (FMLEnvironment.dist.isClient() && player.level().isClientSide) {
            return ClientAccess.isTutorialActive(player);
        }
        return WorldTier.getTier(player) == HAVEN && ((ServerPlayer)player).getStats().getValue(Stats.CUSTOM.get((Object)Apoth.Stats.WORLD_TIERS_ACTIVATED)) == 0;
    }

    public static <T> MapCodec<Map<WorldTier, T>> mapCodec(Codec<T> elementCodec) {
        return Codec.simpleMap(CODEC, elementCodec, (Keyable)Keyable.forStrings(() -> Arrays.stream(WorldTier.values()).map(StringRepresentable::getSerializedName)));
    }

    static {
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])WorldTier.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        CODEC = StringRepresentable.fromValues(WorldTier::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }

    private static class ClientAccess {
        private ClientAccess() {
        }

        private static boolean isTutorialActive(Player player) {
            return WorldTier.getTier(player) == HAVEN && Minecraft.getInstance().player.getStats().getValue(Stats.CUSTOM.get((Object)Apoth.Stats.WORLD_TIERS_ACTIVATED)) == 0;
        }
    }
}

