/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.tiers;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.WeightedEntry;

public record TieredWeights(Map<WorldTier, Weight> weights) {
    public static final MapCodec<TieredWeights> CODEC = Codec.mapEither(Weight.CODEC, (MapCodec)Codec.simpleMap(WorldTier.CODEC, (Codec)Weight.CODEC.codec(), (Keyable)StringRepresentable.keys((StringRepresentable[])WorldTier.values()))).xmap(e -> (Map)e.map(TieredWeights::fillAll, Function.identity()), TieredWeights::toEither).xmap(TieredWeights::new, TieredWeights::weights);
    private static final StreamCodec<ByteBuf, Map<WorldTier, Weight>> MAP_STREAM_CODEC = ByteBufCodecs.map(IdentityHashMap::new, WorldTier.STREAM_CODEC, Weight.STREAM_CODEC, (int)5);
    public static final StreamCodec<ByteBuf, TieredWeights> STREAM_CODEC = MAP_STREAM_CODEC.map(TieredWeights::new, TieredWeights::weights);
    public static TieredWeights EMPTY = new TieredWeights(Map.of());

    public int getWeight(WorldTier tier, float luck) {
        return this.weights.getOrDefault((Object)tier, Weight.ZERO).getWeight(luck);
    }

    private static Map<WorldTier, Weight> fillAll(Weight weight) {
        return Arrays.stream(WorldTier.values()).collect(Collectors.toMap(Function.identity(), v -> weight));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TieredWeights onlyFor(WorldTier tier, int weight, float quality) {
        return new TieredWeights(Map.of(tier, new Weight(weight, quality)));
    }

    public static TieredWeights forTiersAbove(WorldTier tier, int weight, float quality) {
        HashMap<WorldTier, Weight> map = new HashMap<WorldTier, Weight>();
        Weight _weight = new Weight(weight, quality);
        for (int i = tier.ordinal(); i < WorldTier.values().length; ++i) {
            map.put(WorldTier.BY_ID.apply(i), _weight);
        }
        return new TieredWeights(map);
    }

    public static TieredWeights forAllTiers(int weight, float quality) {
        return new TieredWeights(TieredWeights.fillAll(new Weight(weight, quality)));
    }

    private static Either<Weight, Map<WorldTier, Weight>> toEither(Map<WorldTier, Weight> value) {
        if (value.size() == 5) {
            Weight weight = value.getOrDefault((Object)WorldTier.HAVEN, Weight.ZERO);
            if (value.values().stream().allMatch(weight::equals)) {
                return Either.left((Object)weight);
            }
        }
        return Either.right(value);
    }

    public record Weight(int weight, float quality) {
        public static Weight ZERO = new Weight(0, 0.0f);
        public static MapCodec<Weight> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.intRange((int)0, (int)65536).fieldOf("weight").forGetter(Weight::weight), (App)Codec.floatRange((float)-16.0f, (float)16.0f).optionalFieldOf("quality", (Object)Float.valueOf(0.0f)).forGetter(Weight::quality)).apply((Applicative)inst, Weight::new));
        public static StreamCodec<ByteBuf, Weight> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Weight::weight, (StreamCodec)ByteBufCodecs.FLOAT, Weight::quality, Weight::new);

        public int getWeight(float luck) {
            return this.weight + Math.round(luck * this.quality);
        }
    }

    public static class Builder {
        ImmutableMap.Builder<WorldTier, Weight> mapBuilder = ImmutableMap.builder();

        public Builder with(WorldTier tier, int weight, float quality) {
            return this.with(tier, new Weight(weight, quality));
        }

        public Builder with(WorldTier tier, Weight weight) {
            this.mapBuilder.put((Object)tier, (Object)weight);
            return this;
        }

        public TieredWeights build() {
            return new TieredWeights((Map<WorldTier, Weight>)this.mapBuilder.build());
        }
    }

    public static interface Weighted {
        public static final net.minecraft.util.random.Weight SAFE_ZERO = net.minecraft.util.random.Weight.of((int)0);

        public TieredWeights weights();

        default public <T extends Weighted> WeightedEntry.Wrapper<T> wrap(WorldTier tier, float luck) {
            return Weighted.wrap(this, tier, luck);
        }

        public static <T extends Weighted> WeightedEntry.Wrapper<T> wrap(T item, WorldTier tier, float luck) {
            int weight = Math.max(0, item.weights().getWeight(tier, luck));
            if (weight == 0) {
                return new WeightedEntry.Wrapper(item, SAFE_ZERO);
            }
            return WeightedEntry.wrap(item, (int)weight);
        }
    }
}

