/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.loot;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.tiers.TieredDynamicRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class RarityRegistry
extends TieredDynamicRegistry<LootRarity> {
    public static final RarityRegistry INSTANCE = new RarityRegistry();
    protected BiMap<Item, DynamicHolder<LootRarity>> materialMap = HashBiMap.create();
    protected List<LootRarity> sorted = new ArrayList<LootRarity>();

    private RarityRegistry() {
        super(Apotheosis.LOGGER, "rarities", true, false);
    }

    public static boolean isMaterial(Item item) {
        return RarityRegistry.getMaterialRarity(item).isBound();
    }

    public static DynamicHolder<LootRarity> getMaterialRarity(Item item) {
        return (DynamicHolder)RarityRegistry.INSTANCE.materialMap.getOrDefault((Object)item, (Object)INSTANCE.emptyHolder());
    }

    public static List<LootRarity> getSortedRarities() {
        return Collections.unmodifiableList(RarityRegistry.INSTANCE.sorted);
    }

    protected void beginReload() {
        super.beginReload();
        this.materialMap = HashBiMap.create();
        this.sorted.clear();
    }

    protected void onReload() {
        super.onReload();
        for (LootRarity r : this.getValues()) {
            DynamicHolder old = (DynamicHolder)this.materialMap.put((Object)r.getMaterial(), (Object)this.holder(r));
            if (old != null) {
                throw new RuntimeException("Two rarities may not share the same rarity material: " + String.valueOf(this.getKey(r)) + " conflicts with " + String.valueOf(old.getId()));
            }
            this.sorted.add(r);
        }
        this.sorted.sort(Comparator.comparing(LootRarity::sortIndex));
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("rarity"), LootRarity.LOAD_CODEC);
    }

    protected void validateItem(ResourceLocation key, LootRarity item) {
        super.validateItem(key, (CodecProvider)item);
        Preconditions.checkNotNull((Object)item.color());
        Preconditions.checkArgument((item.getMaterial() != null && item.getMaterial() != Items.AIR ? 1 : 0) != 0);
        Preconditions.checkArgument((!item.rules().isEmpty() ? 1 : 0) != 0, (Object)"A rarity must provide base rules.");
    }
}

