/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.advancements.EquippedItemTrigger;
import dev.shadowsoffire.apotheosis.advancements.predicates.AffixItemPredicate;
import dev.shadowsoffire.apotheosis.advancements.predicates.InvaderPredicate;
import dev.shadowsoffire.apotheosis.advancements.predicates.RarityItemPredicate;
import dev.shadowsoffire.apotheosis.advancements.predicates.TypeAwareISP;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ApothAdvancementProvider
extends AdvancementProvider {
    private ApothAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper, List<AdvancementProvider.AdvancementGenerator> subProviders) {
        super(output, registries, existingFileHelper, subProviders);
    }

    public static ApothAdvancementProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        return new ApothAdvancementProvider(output, registries, existingFileHelper, List.of(new ProgressionGenerator()));
    }

    private static Component title(String key) {
        return Apotheosis.lang("advancements", key + ".title", new Object[0]);
    }

    private static Component desc(String key) {
        return Apotheosis.lang("advancements", key + ".desc", new Object[0]);
    }

    private static String loc(String path) {
        return Apotheosis.loc(path).toString();
    }

    private static ItemPredicate ip(TypeAwareISP<?> sub) {
        return new ItemPredicate(Optional.empty(), MinMaxBounds.Ints.ANY, DataComponentPredicate.EMPTY, Map.of(sub.type(), sub));
    }

    private static DynamicHolder<LootRarity> rarity(String path) {
        return RarityRegistry.INSTANCE.holder(Apotheosis.loc(path));
    }

    private static class ProgressionGenerator
    implements AdvancementProvider.AdvancementGenerator {
        private ProgressionGenerator() {
        }

        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
            DynamicHolder<LootRarity> common = ApothAdvancementProvider.rarity("common");
            DynamicHolder<LootRarity> uncommon = ApothAdvancementProvider.rarity("uncommon");
            DynamicHolder<LootRarity> rare = ApothAdvancementProvider.rarity("rare");
            DynamicHolder<LootRarity> epic = ApothAdvancementProvider.rarity("epic");
            DynamicHolder<LootRarity> mythic = ApothAdvancementProvider.rarity("mythic");
            AdvancementHolder root = Advancement.Builder.advancement().display((ItemLike)Apoth.Items.BOSS_SUMMONER.value(), ApothAdvancementProvider.title("progression.root"), ApothAdvancementProvider.desc("progression.root"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.TASK, false, false, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("tick", PlayerTrigger.TriggerInstance.tick()).save(saver, ApothAdvancementProvider.loc("progression/root"));
            AdvancementHolder haven = Advancement.Builder.advancement().display((ItemLike)Items.OAK_SAPLING, ApothAdvancementProvider.title("progression.haven"), ApothAdvancementProvider.desc("progression.haven"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("affixed", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ApothAdvancementProvider.ip(new AffixItemPredicate())})).parent(root).save(saver, ApothAdvancementProvider.loc("progression/haven"));
            AdvancementHolder frontier = Advancement.Builder.advancement().display((ItemLike)Items.IRON_SWORD, ApothAdvancementProvider.title("progression.frontier"), ApothAdvancementProvider.desc("progression.frontier"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("common_helm", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HEAD, common, uncommon, rare, epic, mythic)).addCriterion("common_chest", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.CHEST, common, uncommon, rare, epic, mythic)).addCriterion("common_legs", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.LEGS, common, uncommon, rare, epic, mythic)).addCriterion("common_feet", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.FEET, common, uncommon, rare, epic, mythic)).addCriterion("common_hand", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HAND, common, uncommon, rare, epic, mythic)).parent(haven).save(saver, ApothAdvancementProvider.loc("progression/frontier"));
            AdvancementHolder ascent = Advancement.Builder.advancement().display((ItemLike)Items.BLAZE_POWDER, ApothAdvancementProvider.title("progression.ascent"), ApothAdvancementProvider.desc("progression.ascent"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("uncommon_helm", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HEAD, uncommon, rare, epic, mythic)).addCriterion("uncommon_chest", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.CHEST, uncommon, rare, epic, mythic)).addCriterion("uncommon_legs", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.LEGS, uncommon, rare, epic, mythic)).addCriterion("uncommon_feet", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.FEET, uncommon, rare, epic, mythic)).addCriterion("uncommon_hand", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HAND, uncommon, rare, epic, mythic)).addCriterion("kill_apothic_invader", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)InvaderPredicate.INSTANCE))).parent(frontier).save(saver, ApothAdvancementProvider.loc("progression/ascent"));
            AdvancementHolder summit = Advancement.Builder.advancement().display((ItemLike)Items.NETHERITE_SWORD, ApothAdvancementProvider.title("progression.summit"), ApothAdvancementProvider.desc("progression.summit"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("rare_helm", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HEAD, rare, epic, mythic)).addCriterion("rare_chest", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.CHEST, rare, epic, mythic)).addCriterion("rare_legs", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.LEGS, rare, epic, mythic)).addCriterion("rare_feet", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.FEET, rare, epic, mythic)).addCriterion("rare_hand", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HAND, rare, epic, mythic)).addCriterion("kill_wither", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.WITHER))).parent(ascent).save(saver, ApothAdvancementProvider.loc("progression/summit"));
            AdvancementHolder pinnacle = Advancement.Builder.advancement().display((ItemLike)Items.END_CRYSTAL, ApothAdvancementProvider.title("progression.pinnacle"), ApothAdvancementProvider.desc("progression.pinnacle"), Apotheosis.loc("textures/advancements/bg/apoth.png"), AdvancementType.CHALLENGE, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("epic_helm", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HEAD, epic, mythic)).addCriterion("epic_chest", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.CHEST, epic, mythic)).addCriterion("epic_legs", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.LEGS, epic, mythic)).addCriterion("epic_feet", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.FEET, epic, mythic)).addCriterion("epic_hand", ProgressionGenerator.rarityInSlot(EquipmentSlotGroup.HAND, epic, mythic)).addCriterion("kill_ender_dragon", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.ENDER_DRAGON))).parent(summit).save(saver, ApothAdvancementProvider.loc("progression/pinnacle"));
        }

        @SafeVarargs
        private static Criterion<?> rarityInSlot(EquipmentSlotGroup slot, DynamicHolder<LootRarity> ... rarities) {
            return EquippedItemTrigger.TriggerInstance.hasItems(slot, ApothAdvancementProvider.ip(new RarityItemPredicate(ApothMiscUtil.linkedSet(rarities))));
        }
    }
}

