/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.affix.effect.StoneformingAffix;
import dev.shadowsoffire.placebo.PlaceboClient;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.joml.Matrix4f;

public record StoneformingTooltipRenderer(StoneformingComponent comp) implements ClientTooltipComponent
{
    public static final ResourceLocation SOCKET = Apotheosis.loc("textures/gui/socket.png");
    public static final Component EMPTY_SPACE_PLACEHOLDER = Component.literal((String)" ".repeat(8));

    public int getHeight() {
        Objects.requireNonNull(Minecraft.getInstance().font);
        return 9 + 2;
    }

    public int getWidth(Font font) {
        return font.width((FormattedText)StoneformingTooltipRenderer.getText(this.comp.inst));
    }

    public void renderImage(Font font, int x, int y, GuiGraphics gfx) {
        if (this.affix().getCandidates().size() == 0) {
            return;
        }
        String text = I18n.get((String)"affix.apotheosis.stoneforming.desc", (Object[])new Object[]{"<M1>", "<M2>"});
        int xPos = font.width(text.substring(0, text.indexOf("<M1>") + 1));
        StoneformingAffix affix = this.affix();
        Block[] selected = new Block[3];
        int start = (int)(PlaceboClient.ticks / 20L) * 3;
        for (int i = 0; i < 3; ++i) {
            selected[i] = (Block)affix.getCandidates().get((start + i) % affix.getCandidates().size()).value();
        }
        PoseStack pose = gfx.pose();
        pose.pushPose();
        pose.translate(0.0f, -0.25f, 0.0f);
        pose.scale(0.5f, 0.5f, 1.0f);
        for (Block block : selected) {
            ItemStack stack = new ItemStack((ItemLike)block);
            gfx.renderFakeItem(stack, (x + xPos) * 2 + 8, y * 2);
            xPos += 10;
        }
        pose.popPose();
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        font.drawInBatch(StoneformingTooltipRenderer.getText(this.comp.inst()), (float)x, (float)y, 0xAABBCC, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    private StoneformingAffix affix() {
        return (StoneformingAffix)this.comp.inst.getAffix();
    }

    public static Component getText(AffixInstance inst) {
        MutableComponent blockName = ((StoneformingAffix)inst.getAffix()).getTarget(inst).getName().withStyle(ChatFormatting.BLUE);
        MutableComponent afxDesc = Apotheosis.lang("affix", "stoneforming.desc", Component.literal((String)" ".repeat(8)), blockName);
        return Apotheosis.lang("text", "dot_prefix", afxDesc).withStyle(ChatFormatting.YELLOW);
    }

    public record StoneformingComponent(AffixInstance inst) implements TooltipComponent
    {
    }
}

