/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.systems.wanderer.WandererTrade;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;

public class AffixTrade
implements WandererTrade {
    public static Codec<AffixTrade> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemCost.CODEC.fieldOf("input_1").forGetter(trade -> trade.price), (App)ItemCost.CODEC.optionalFieldOf("input_2").forGetter(trade -> trade.price2), (App)PlaceboCodecs.setOf(LootRarity.CODEC).optionalFieldOf("rarities", Set.of()).forGetter(a -> a.rarities), (App)AffixLootRegistry.INSTANCE.holderCodec().listOf().fieldOf("entries").forGetter(a -> a.entries), (App)Codec.BOOL.optionalFieldOf("rare", (Object)false).forGetter(trade -> trade.rare)).apply((Applicative)inst, AffixTrade::new));
    protected final ItemCost price;
    protected final Optional<ItemCost> price2;
    protected final Set<LootRarity> rarities;
    protected final List<DynamicHolder<AffixLootEntry>> entries;
    protected final boolean rare;

    public AffixTrade(ItemCost price, Optional<ItemCost> price2, Set<LootRarity> rarities, List<DynamicHolder<AffixLootEntry>> entries, boolean rare) {
        this.price = price;
        this.price2 = price2;
        this.rarities = rarities;
        this.entries = entries;
        this.rare = rare;
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource rand) {
        ItemStack affixItem;
        if (trader.level().isClientSide) {
            return null;
        }
        Player player = trader.level().getNearestPlayer(trader, -1.0);
        if (player == null) {
            return null;
        }
        GenContext ctx = GenContext.forPlayer(rand, player);
        if (this.entries.isEmpty()) {
            LootRarity selectedRarity = LootRarity.random(ctx, this.rarities);
            affixItem = LootController.createRandomLootItem(ctx, selectedRarity);
        } else {
            List<WeightedEntry.Wrapper> resolved = this.entries.stream().map(this::unwrap).filter(Objects::nonNull).map(e -> e.wrap(ctx.tier(), ctx.luck())).toList();
            AffixLootEntry entry = (AffixLootEntry)((WeightedEntry.Wrapper)WeightedRandom.getRandomItem((RandomSource)rand, resolved).get()).data();
            LootRarity selectedRarity = LootRarity.random(ctx, this.rarities.isEmpty() ? entry.rarities() : this.rarities);
            affixItem = LootController.createLootItem(entry.stack(), selectedRarity, ctx);
        }
        if (affixItem.isEmpty()) {
            return null;
        }
        affixItem.set(Apoth.Components.FROM_TRADER, (Object)true);
        return new MerchantOffer(this.price, this.price2, affixItem, 1, 100, 1.0f);
    }

    public boolean isRare() {
        return this.rare;
    }

    public Codec<? extends WandererTrade> getCodec() {
        return CODEC;
    }

    private AffixLootEntry unwrap(DynamicHolder<AffixLootEntry> holder) {
        if (!holder.isBound()) {
            Apotheosis.LOGGER.error("An AffixTrade failed to resolve the Affix Loot Entry {}!", (Object)holder.getId());
            return null;
        }
        return (AffixLootEntry)holder.get();
    }
}

