/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixBuilder;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.mixin.LivingEntityInvoker;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class MobEffectAffix
extends Affix {
    public static final Codec<MobEffectAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(MobEffectAffix.affixDef(), (App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("mob_effect").forGetter(a -> a.effect), (App)Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)LootRarity.mapCodec(EffectData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types), (App)Codec.BOOL.optionalFieldOf("stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply), (App)Codec.intRange((int)1, (int)255).optionalFieldOf("stacking_limit", (Object)255).forGetter(a -> a.stackingLimit)).apply((Applicative)inst, MobEffectAffix::new));
    protected final Holder<MobEffect> effect;
    protected final Target target;
    protected final Map<LootRarity, EffectData> values;
    protected final Set<LootCategory> types;
    protected final boolean stackOnReapply;
    protected final int stackingLimit;

    public MobEffectAffix(AffixDefinition def, Holder<MobEffect> effect, Target target, Map<LootRarity, EffectData> values, Set<LootCategory> types, boolean stackOnReapply, int stackingLimit) {
        super(def);
        this.effect = effect;
        this.target = target;
        this.values = values;
        this.types = types;
        this.stackOnReapply = stackOnReapply;
        this.stackingLimit = stackingLimit;
    }

    @Override
    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        MobEffectInstance effectInst = this.values.get(inst.getRarity()).build(this.effect, inst.level());
        MutableComponent comp = this.target.toComponent(MobEffectAffix.toComponent(effectInst, ctx.tickRate()));
        int cooldown = this.getCooldown(inst.getRarity());
        if (cooldown != 0) {
            MutableComponent cd = Component.translatable((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.formatTickDuration((int)cooldown, (float)ctx.tickRate())});
            comp = comp.append(" ").append((Component)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.append(" ").append((Component)Component.translatable((String)"affix.apotheosis.stacking"));
        }
        return comp;
    }

    @Override
    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        int cooldown;
        MutableComponent maxComp;
        MutableComponent minComp;
        LootRarity rarity = inst.getRarity();
        MobEffectInstance effectInst = this.values.get(rarity).build(this.effect, inst.level());
        MutableComponent comp = this.target.toComponent(MobEffectAffix.toComponent(effectInst, ctx.tickRate()));
        MobEffectInstance min = this.values.get(rarity).build(this.effect, 0.0f);
        MobEffectInstance max = this.values.get(rarity).build(this.effect, 1.0f);
        if (min.getAmplifier() != max.getAmplifier()) {
            minComp = min.getAmplifier() == 0 ? Component.literal((String)"I") : Component.translatable((String)("potion.potency." + min.getAmplifier()));
            maxComp = Component.translatable((String)("potion.potency." + max.getAmplifier()));
            comp.append((Component)MobEffectAffix.valueBounds((Component)minComp, (Component)maxComp));
        }
        if (!((MobEffect)this.effect.value()).isInstantenous() && min.getDuration() != max.getDuration()) {
            minComp = MobEffectUtil.formatDuration((MobEffectInstance)min, (float)1.0f, (float)ctx.tickRate());
            maxComp = MobEffectUtil.formatDuration((MobEffectInstance)max, (float)1.0f, (float)ctx.tickRate());
            comp.append((Component)MobEffectAffix.valueBounds((Component)minComp, (Component)maxComp));
        }
        if ((cooldown = this.getCooldown(rarity)) != 0) {
            MutableComponent cd = Component.translatable((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.formatTickDuration((int)cooldown, (float)ctx.tickRate())});
            comp = comp.append(" ").append((Component)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.append(" ").append((Component)Component.translatable((String)"affix.apotheosis.stacking"));
        }
        return comp;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return (this.types.isEmpty() || this.types.contains(cat)) && this.values.containsKey(rarity);
    }

    @Override
    public void doPostHurt(AffixInstance inst, LivingEntity user, DamageSource source) {
        Entity entity;
        if (this.target == Target.HURT_SELF) {
            this.applyEffect(user, inst.getRarity(), inst.level());
        } else if (this.target == Target.HURT_ATTACKER && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)entity;
            this.applyEffect(tLiving, inst.getRarity(), inst.level());
        }
    }

    @Override
    public void doPostAttack(AffixInstance inst, LivingEntity user, Entity target) {
        if (this.target == Target.ATTACK_SELF) {
            this.applyEffect(user, inst.getRarity(), inst.level());
        } else if (this.target == Target.ATTACK_TARGET && target instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)target;
            this.applyEffect(tLiving, inst.getRarity(), inst.level());
        }
    }

    @Override
    public void onBlockBreak(AffixInstance inst, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        if (this.target == Target.BREAK_SELF) {
            this.applyEffect((LivingEntity)player, inst.getRarity(), inst.level());
        }
    }

    @Override
    public void onProjectileImpact(float level, LootRarity rarity, Projectile proj, HitResult res, HitResult.Type type) {
        Entity entity;
        if (type == HitResult.Type.ENTITY && (entity = ((EntityHitResult)res).getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            switch (this.target.ordinal()) {
                case 5: {
                    Entity entity2;
                    if (!(proj instanceof AbstractArrow) || !((entity2 = proj.getOwner()) instanceof LivingEntity)) break;
                    LivingEntity owner = (LivingEntity)entity2;
                    this.applyEffect(owner, rarity, level);
                    break;
                }
                case 6: {
                    if (!(proj instanceof AbstractArrow)) break;
                    this.applyEffect(target, rarity, level);
                    break;
                }
                case 9: {
                    Entity entity3 = proj.getOwner();
                    if (!(entity3 instanceof LivingEntity)) break;
                    LivingEntity owner = (LivingEntity)entity3;
                    this.applyEffect(owner, rarity, level);
                    break;
                }
                case 10: {
                    this.applyEffect(target, rarity, level);
                    break;
                }
            }
        }
    }

    @Override
    public float onShieldBlock(AffixInstance inst, LivingEntity entity, DamageSource source, float amount) {
        Entity entity2;
        if (this.target == Target.BLOCK_SELF) {
            this.applyEffect(entity, inst.getRarity(), inst.level());
        } else if (this.target == Target.BLOCK_ATTACKER && (entity2 = source.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            this.applyEffect(target, inst.getRarity(), inst.level());
        }
        return amount;
    }

    protected int getCooldown(LootRarity rarity) {
        EffectData data = this.values.get(rarity);
        return data.cooldown;
    }

    private void applyEffect(LivingEntity target, LootRarity rarity, float level) {
        if (target.level().isClientSide()) {
            return;
        }
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0 && MobEffectAffix.isOnCooldown(this.id(), cooldown, target)) {
            return;
        }
        EffectData data = this.values.get(rarity);
        MobEffectInstance inst = target.getEffect(this.effect);
        if (this.stackOnReapply && inst != null) {
            if (inst != null) {
                int duration = Math.max(inst.getDuration(), data.duration.getInt(level));
                int amp = Math.min(this.stackingLimit, inst.getAmplifier() + 1 + data.amplifier.getInt(level));
                MobEffectInstance newInst = new MobEffectInstance(this.effect, duration, amp, inst.isAmbient(), inst.isVisible());
                inst.update(newInst);
                ((LivingEntityInvoker)target).callOnEffectUpdated(inst, true, null);
                inst.onEffectStarted(target);
            }
        } else {
            target.addEffect(data.build(this.effect, level));
        }
        MobEffectAffix.startCooldown(this.id(), target);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static Component toComponent(MobEffectInstance inst, float tickRate) {
        MutableComponent mutablecomponent = Component.translatable((String)inst.getDescriptionId());
        Holder mobeffect = inst.getEffect();
        if (inst.getAmplifier() > 0) {
            mutablecomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.translatable((String)("potion.potency." + inst.getAmplifier()))});
        }
        if (inst.getDuration() > 20) {
            mutablecomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.formatDuration((MobEffectInstance)inst, (float)1.0f, (float)tickRate)});
        }
        return mutablecomponent.withStyle(((MobEffect)mobeffect.value()).getCategory().getTooltipFormatting());
    }

    public static enum Target {
        ATTACK_SELF("attack_self"),
        ATTACK_TARGET("attack_target"),
        HURT_SELF("hurt_self"),
        HURT_ATTACKER("hurt_attacker"),
        BREAK_SELF("break_self"),
        ARROW_SELF("arrow_self"),
        ARROW_TARGET("arrow_target"),
        BLOCK_SELF("block_self"),
        BLOCK_ATTACKER("block_attacker"),
        PROJECTILE_SELF("projectile_self"),
        PROJECTILE_TARGET("projectile_target");

        public static final Codec<Target> CODEC;
        private final String id;

        private Target(String id) {
            this.id = id;
        }

        public MutableComponent toComponent(Object ... args) {
            return Component.translatable((String)("affix.apotheosis.target." + this.id), (Object[])args);
        }

        static {
            CODEC = PlaceboCodecs.enumCodec(Target.class);
        }
    }

    public record EffectData(StepFunction duration, StepFunction amplifier, int cooldown) {
        private static Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.fieldOf("duration").forGetter(EffectData::duration), (App)StepFunction.CODEC.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public MobEffectInstance build(Holder<MobEffect> effect, float level) {
            return new MobEffectInstance(effect, this.duration.getInt(level), this.amplifier.getInt(level));
        }
    }

    public static class Builder
    extends AffixBuilder<Builder> {
        protected final Holder<MobEffect> effect;
        protected final Target target;
        protected final Map<LootRarity, EffectData> values = new LinkedHashMap<LootRarity, EffectData>();
        protected final Set<LootCategory> categories = new LinkedHashSet<LootCategory>();
        protected boolean stacking = false;
        private int limit = 255;

        public Builder(Holder<MobEffect> effect, Target target) {
            this.effect = effect;
            this.target = target;
        }

        public Builder categories(LootCategory ... cats) {
            for (LootCategory cat : cats) {
                this.categories.add(cat);
            }
            return this;
        }

        public Builder value(LootRarity rarity, int duration, int amplifier, int cooldown) {
            return this.value(rarity, StepFunction.constant((float)duration), StepFunction.constant((float)amplifier), cooldown);
        }

        public Builder value(LootRarity rarity, int minDuration, int maxDuration, int amplifier, int cooldown) {
            return this.value(rarity, minDuration, maxDuration, StepFunction.constant((float)amplifier), cooldown);
        }

        public Builder value(LootRarity rarity, int minDuration, int maxDuration, StepFunction amplifier, int cooldown) {
            return this.value(rarity, StepFunction.fromBounds((float)minDuration, (float)maxDuration, (float)20.0f), amplifier, cooldown);
        }

        public Builder value(LootRarity rarity, StepFunction duration, StepFunction amplifier, int cooldown) {
            return this.value(rarity, new EffectData(duration, amplifier, cooldown));
        }

        public Builder value(LootRarity rarity, EffectData value) {
            this.values.put(rarity, value);
            return this;
        }

        public Builder stacking() {
            this.stacking = true;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public MobEffectAffix build() {
            Preconditions.checkArgument((!this.values.isEmpty() ? 1 : 0) != 0);
            return new MobEffectAffix(this.definition, this.effect, this.target, this.values, this.categories, this.stacking, this.limit);
        }
    }
}

