/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.mixin;

import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    public MixinLivingEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void lunarEntityTick(CallbackInfo ci) {
        EnhancedCelestials.lunarForecastWorldData(this.level()).ifPresent(data -> data.currentLunarEvent().livingEntityTick((LivingEntity)this));
    }

    @Inject(method={"checkBedExists()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void blockSleeping(CallbackInfoReturnable<Boolean> cir) {
        EnhancedCelestials.lunarForecastWorldData(this.level()).ifPresent(data -> {
            if (data.currentLunarEvent().blockSleeping((LivingEntity)this)) {
                if ((LivingEntity)this instanceof ServerPlayer) {
                    ((ServerPlayer)this).displayClientMessage((Component)Component.translatable((String)"enhancedcelestials.sleep.fail").withStyle(ChatFormatting.RED), true);
                }
                cir.setReturnValue((Object)false);
            }
        });
    }
}

