/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.util.EffectUtil;

public class MahouTsukaiTeleporter {
    public static void teleport(Entity entity, double x, double y, double z, ResourceLocation dim) {
        MahouTsukaiTeleporter.teleport(entity, dim, new Vec3(x, y, z));
    }

    public static void teleport(Entity entity, ResourceLocation destination, Vec3 pos) {
        if (entity != null) {
            if (EffectUtil.compareDimensions(EffectUtil.getDimension(entity.level()), destination)) {
                entity.teleportTo(pos.x(), pos.y(), pos.z());
            } else if (!entity.level().isClientSide) {
                ((ServerLevel)entity.level()).getServer().execute(() -> {
                    ServerLevel sw = EffectUtil.getNewDimensionByName((ServerLevel)entity.level(), destination);
                    if (entity instanceof ServerPlayer) {
                        ((ServerPlayer)entity).teleportTo(sw, pos.x(), pos.y(), pos.z(), entity.getYRot(), entity.getXRot());
                    } else {
                        entity.changeDimension(new DimensionTransition(sw, pos, new Vec3(0.0, 0.0, 0.0), entity.xRot, entity.yRot, false, new DimensionTransition.PostDimensionTransition(){

                            public void onTransition(Entity entity) {
                            }
                        }));
                    }
                });
            }
        }
    }
}

