/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.projection;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.fluids.MurkyWaterBlock;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.MahoujinTickingTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class PowerConsolidationMahoujinTileEntity
extends MahoujinTickingTileEntity {
    public static final String LAKED = "MAHOUTSUKAI_NUM_TIMES_LAKED";
    private int numTimesLaked = 0;

    public PowerConsolidationMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.powerConsolidation.get(), p, bs);
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt(LAKED, this.numTimesLaked);
        super.saveAdditional(compound, provider);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.numTimesLaked = compound.getInt(LAKED);
        super.loadAdditional(compound, provider);
    }

    @Override
    public int blockCycle() {
        return MTConfig.POWER_CONSOLIDATION_LAKE_CYCLE;
    }

    @Override
    public void mahoujinTick(Level level, BlockPos blockPos, BlockState blockState, MahoujinTickingTileEntity blockEntity) {
        int radius = MTConfig.POWER_CONSOLIDATION_LAKE_RADIUS;
        if (this.numTimesLaked >= radius - 1) {
            level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
        } else {
            boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.worldPosition, level, this.getCasterUUID(), MTConfig.POWER_CONSOLIDATION_LAKE_MANA_COST);
            if (nearbyBatteriesGaveMana || this.getCaster() != null && PlayerManaManager.drainMana(this.getCaster(), MTConfig.POWER_CONSOLIDATION_LAKE_MANA_COST, false, false) == MTConfig.POWER_CONSOLIDATION_LAKE_MANA_COST) {
                this.createLake();
                ++this.numTimesLaked;
            } else if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                MahouTsukaiMod.logger.debug("Power consolidation is failing because of mana.");
                MahouTsukaiMod.logger.debug("More info for debugging.");
                MahouTsukaiMod.logger.debug("getCaster():" + String.valueOf(this.getCaster()));
                MahouTsukaiMod.logger.debug("getCasterUUID():" + String.valueOf(this.getCasterUUID()));
                MahouTsukaiMod.logger.debug("Required mana:" + MTConfig.POWER_CONSOLIDATION_LAKE_MANA_COST);
                if (this.getCaster() != null) {
                    MahouTsukaiMod.logger.debug("Caster mana:" + String.valueOf(Utils.getPlayerMahou(this.getCaster())));
                }
            }
        }
    }

    public void createLake() {
        int r = this.numTimesLaked + 1;
        Stream lst = BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-r - 1, -r - 1, -r - 1), (BlockPos)this.worldPosition.offset(r + 1, r + 1, r + 1));
        lst.forEach(p -> {
            if (p.distSqr((Vec3i)this.worldPosition) < (double)(r * r + 1) && p.getY() < this.worldPosition.getY() && this.level.getBlockEntity(p) == null) {
                if ((double)(this.numTimesLaked * this.numTimesLaked) - p.distSqr((Vec3i)this.worldPosition) <= 1.0) {
                    EffectUtil.tryChangeBlockState(false, p, Blocks.DIRT.defaultBlockState(), this.level, this.getCaster());
                } else {
                    EffectUtil.tryChangeBlockState(false, p, ((MurkyWaterBlock)((Object)((Object)ModBlocks.murkyFluid.get()))).defaultBlockState(), this.level, this.getCaster());
                }
            }
        });
    }
}

