/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.mana.ActiveCircleConfig;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.MahoujinTickingTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class AlchemicalExchangeMahoujinTileEntity
extends MahoujinTickingTileEntity {
    private long placedTime = 0L;
    private int processingLayer = 0;
    private static final String PLACED_TIME_TAG = "MAHOUTSUKAI_PLACED_TIME_TAG";
    private static final String PROCESSING_LAYER_TAG = "MAHOUTSUKAI_PROCESSING_LAYER_TAG";
    private static HashSet<BlockState> dirtClass = new HashSet();
    private static HashSet<BlockState> stoneClass = new HashSet();
    private static HashSet<BlockState> gemClass = new HashSet();
    private static HashSet<BlockState> metalClass = new HashSet();
    private static HashSet<BlockState> clayClass = new HashSet();
    private static HashSet<BlockState> woodClass = new HashSet();
    private static HashSet<BlockState> grassClass = new HashSet();
    private static HashSet<BlockState> specialClass = new HashSet();
    private static HashSet<BlockState> fluidClass = new HashSet();
    private static HashSet<BlockState> movingFluidClass = new HashSet();
    private static ArrayList<HashSet> blockClasses = new ArrayList();
    private ArrayList<Integer> indices = null;

    public AlchemicalExchangeMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.alchemicalExchange.get(), p, bs);
    }

    @Override
    public int blockCycle() {
        return MTConfig.ALCHEMICAL_EXCHANGE_BLOCK_CYCLE;
    }

    @Override
    public void mahoujinTick(Level level, BlockPos blockPos, BlockState blockState, MahoujinTickingTileEntity blockEntity) {
        if (ActiveCircleConfig.tryToOperate(this, this.getCasterUUID())) {
            this.transformLayers();
        }
    }

    public void setPlacedTime(long t) {
        this.placedTime = t;
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt(PROCESSING_LAYER_TAG, this.processingLayer);
        compound.putLong(PLACED_TIME_TAG, this.placedTime);
        super.saveAdditional(compound, provider);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.placedTime = compound.getLong(PLACED_TIME_TAG);
        this.processingLayer = compound.getInt(PROCESSING_LAYER_TAG);
        super.loadAdditional(compound, provider);
    }

    public void transformLayers() {
        long p = this.level.getDayTime() % 24000L;
        if (p < 0L) {
            p += 24000L;
        }
        p -= p % 20L;
        if (this.indices == null) {
            this.indices = this.generateIndices(blockClasses, this.getCaster());
        }
        if (p == this.placedTime) {
            this.processingLayer = 1;
            this.transformLayer(this.processingLayer, this.indices, this.getCaster());
        } else if (this.processingLayer > 0) {
            this.transformLayer(this.processingLayer, this.indices, this.getCaster());
            ++this.processingLayer;
            if (this.processingLayer >= MTConfig.ALCHEMICAL_EXCHANGE_HEIGHT) {
                this.processingLayer = 0;
                this.indices = null;
            }
        }
    }

    public ArrayList<Integer> generateIndices(ArrayList<HashSet> lengths, Player player) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int z = 0; z < lengths.size(); ++z) {
            if (player != null) {
                ret.add(player.random.nextInt(Math.max(1, lengths.get(z).size())));
                continue;
            }
            ret.add(this.level.random.nextInt(Math.max(1, lengths.get(z).size())));
        }
        return ret;
    }

    public boolean transformLayer(int layer, ArrayList<Integer> indices, Player player) {
        Stream layerBlocks = BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-2, -layer, -2), (BlockPos)this.worldPosition.offset(2, -layer, 2));
        layerBlocks.forEach(tmp -> {
            Block b = this.level.getBlockState(tmp).getBlock();
            if (!Utils.isBlockAir(this.level, tmp)) {
                boolean nearbyBatteriesGaveMana;
                int liquid = this.level.random.nextInt(2);
                BlockState tb = null;
                if (b instanceof LiquidBlock) {
                    tb = new ArrayList<BlockState>(fluidClass).get(liquid);
                } else {
                    for (int i = 0; i < blockClasses.size(); ++i) {
                        int target;
                        HashSet s = blockClasses.get(i);
                        if (!s.contains(this.level.getBlockState(tmp)) || (target = i < indices.size() ? (Integer)indices.get(i) : 0) >= s.size()) continue;
                        tb = (BlockState)new ArrayList(s).get(target);
                        break;
                    }
                }
                if (tb != null && ((nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.worldPosition, this.level, this.getCasterUUID(), MTConfig.ALCHEMICAL_EXCHANGE_MANA_COST)) || player != null && PlayerManaManager.drainMana(player, MTConfig.ALCHEMICAL_EXCHANGE_MANA_COST, false, false) == MTConfig.ALCHEMICAL_EXCHANGE_MANA_COST)) {
                    EffectUtil.tryChangeBlockState(false, tmp, tb, this.level, this.getCaster());
                    if (player != null) {
                        PlayerManaManager.updateClientMahou((ServerPlayer)player, Utils.getPlayerMahou(player));
                    }
                }
            }
        });
        return true;
    }

    public static void init() {
        try {
            blockClasses = new ArrayList();
            dirtClass = new HashSet();
            stoneClass = new HashSet();
            metalClass = new HashSet();
            gemClass = new HashSet();
            clayClass = new HashSet();
            woodClass = new HashSet();
            specialClass = new HashSet();
            grassClass = new HashSet();
            fluidClass = new HashSet();
            movingFluidClass = new HashSet();
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(dirtClass, MTConfig.ALCHEMICAL_DIRT_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(stoneClass, MTConfig.ALCHEMICAL_STONE_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(metalClass, MTConfig.ALCHEMICAL_METAL_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(gemClass, MTConfig.ALCHEMICAL_GEM_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(clayClass, MTConfig.ALCHEMICAL_CLAY_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(woodClass, MTConfig.ALCHEMICAL_WOOD_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(specialClass, MTConfig.ALCHEMICAL_SPECIAL_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(grassClass, MTConfig.ALCHEMICAL_GRASS_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(fluidClass, MTConfig.ALCHEMICAL_FLUID_CLASS);
            AlchemicalExchangeMahoujinTileEntity.addBlocksToList(movingFluidClass, MTConfig.ALCHEMICAL_MOVING_FLUID_CLASS);
            blockClasses.add(dirtClass);
            blockClasses.add(stoneClass);
            blockClasses.add(metalClass);
            blockClasses.add(gemClass);
            blockClasses.add(clayClass);
            blockClasses.add(woodClass);
            blockClasses.add(specialClass);
            blockClasses.add(grassClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addBlocksToList(HashSet<BlockState> lst, List<String> registryNames) {
        for (String registryName : registryNames) {
            String s = registryName;
            String[] variant = s.split("@");
            if (variant.length <= 0) continue;
            Block b = Utils.getBlockFromRegistryName(variant[0]);
            if (b == null || b == Blocks.AIR) {
                Iterable<Holder<Block>> tag = Utils.getBlockTagFromRegistryName(variant[0]);
                if (!tag.iterator().hasNext()) {
                    Utils.err("Mahou Tsukai Alchemical Exchange: Registry block " + s + " not found.");
                }
                for (Holder<Block> blockHolder : tag) {
                    Block taggedBlock = (Block)blockHolder.value();
                    lst.add(taggedBlock.defaultBlockState());
                }
                continue;
            }
            BlockState bs = b.defaultBlockState();
            lst.add(bs);
        }
    }
}

