/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class DisplacementBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    private static final boolean livingOnly = true;

    public DisplacementBoundaryMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.displacementBoundary.get(), true, p, bs);
    }

    @Override
    public int getManaCost() {
        return MTConfig.DISPLACEMENT_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.DISPLACEMENT_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.DISPLACEMENT_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.DISPLACEMENT_BARRIER_RADIUS;
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        double x1 = this.worldPosition.getX() - this.getBarrierRadius() + 1;
        double x2 = this.worldPosition.getX() + this.getBarrierRadius() - 1;
        double z1 = this.worldPosition.getZ() - this.getBarrierRadius() + 1;
        double z2 = this.worldPosition.getZ() + this.getBarrierRadius() - 1;
        Player caster = this.getCaster();
        for (Entity entity : entities) {
            if (ContractMahoujinTileEntity.isImmuneToSpell(this.level, this.getCasterUUID(), entity) || entity instanceof ArmorStand) continue;
            double x = entity.getX();
            double y = entity.getY();
            double z = entity.getZ();
            Vec3 lv = entity.getLookAngle().normalize();
            double lx = lv.x;
            double lz = lv.z;
            BlockPos newPos = this.getDestination(this, x, y, z, lx, lz);
            BlockPos oldPos = Utils.toBlockPos(x, y, z);
            boolean doSwitch = (double)oldPos.getX() > x1 && (double)oldPos.getX() < x2 && (double)oldPos.getZ() > z1 && (double)oldPos.getZ() < z2;
            if (!doSwitch) continue;
            BlockPos ascendedPos = this.getAscendedDestination(newPos, this.level, entity);
            if (ascendedPos != null) {
                newPos = ascendedPos;
            }
            if (this.level.isClientSide) continue;
            if (entity instanceof ServerPlayer && !((ServerPlayer)entity).isSpectator() && !((ServerPlayer)entity).isCreative()) {
                ((ServerPlayer)entity).connection.teleport((double)newPos.getX(), (double)newPos.getY(), (double)newPos.getZ(), entity.getYRot(), entity.getXRot());
                continue;
            }
            entity.teleportTo((double)newPos.getX(), (double)newPos.getY(), (double)newPos.getZ());
        }
    }

    public BlockPos getDestination(DisplacementBoundaryMahoujinTileEntity te, double x, double y, double z, double lx, double lz) {
        double nz;
        BlockPos ret = null;
        double nx = x;
        double ny = y;
        boolean i = false;
        Vec3 look = new Vec3(lx, 0.0, lz);
        look = look.normalize();
        lx = look.x;
        lz = look.z;
        if (te != null) {
            double x1 = te.getBlockPos().getX() - this.getBarrierRadius();
            double x2 = x1 + (double)(this.getBarrierRadius() * 2);
            double z1 = te.getBlockPos().getZ() - this.getBarrierRadius();
            double z2 = z1 + (double)(this.getBarrierRadius() * 2);
            for (nz = z; nx > x1 && nx < x2 && nz > z1 && nz < z2; nx += lx, nz += lz) {
            }
        }
        ret = Utils.toBlockPos(nx, ny, nz);
        return ret;
    }

    public BlockPos getAscendedDestination(BlockPos p, Level w, Entity e) {
        BlockPos tmp = p;
        while (tmp.getY() < w.getMaxBuildHeight()) {
            if (this.okPosition(tmp, w, e)) {
                return tmp;
            }
            tmp = tmp.above();
        }
        return null;
    }

    public boolean okPosition(BlockPos p, Level w, Entity e) {
        int i = 0;
        while ((float)i < e.getBbHeight()) {
            BlockPos tmp = p.offset(0, i, 0);
            if (!Utils.isBlockAir(this.level, tmp)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((ItemLike)ModItems.boundaryDisplacementScroll.get());
    }
}

