/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.sounds;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.sounds.ModSounds;

public class BeamMovingSound
extends AbstractTickableSoundInstance {
    private final Player player;
    private final MysticStaffBeamMahoujinEntity beam;
    private float lastvolume = 0.0f;

    public BeamMovingSound(Player player, MysticStaffBeamMahoujinEntity beam) {
        super((SoundEvent)ModSounds.BEAM_TWINKLE.get(), SoundSource.NEUTRAL, RandomSource.create());
        this.player = player;
        this.beam = beam;
        this.attenuation = SoundInstance.Attenuation.NONE;
        this.looping = true;
        this.delay = 0;
        this.volume = 0.001f;
        this.lastvolume = 0.001f;
    }

    public void tick() {
        if (this.beam.isAlive()) {
            float len = this.beam.getBeamLength();
            float pt = this.beam.getRotationPitch();
            float yw = this.beam.getRotationYaw();
            Vec3 direction = Vec3.directionFromRotation((float)(90.0f - pt), (float)(360.0f - yw + 180.0f)).normalize();
            Vec3 position = this.beam.position();
            double d = this.distanceToLine(position, position.add(direction.scale((double)len)), this.player.position().add(new Vec3(0.0, 1.0, 0.0)));
            this.lastvolume = this.volume;
            if (d > 128.0) {
                this.volume = 0.0f;
            } else {
                this.pitch = 0.3f + 0.4f * this.beam.getSphereSize() / 0.7f;
                this.pitch += this.beam.getBeamSize() * 0.4f / 0.7f;
                this.volume = (float)Math.min((double)(this.beam.getSphereSize() * 0.1f + this.beam.getBeamSize() * 0.1f) * (4.0 / d), 1.0);
                this.volume = (float)((double)this.volume * MTConfig.MYSTIC_STAFF_BEAM_VOLUME_FACTOR);
            }
        } else {
            this.stop();
        }
    }

    public double distanceToLine(Vec3 v, Vec3 w, Vec3 p) {
        Vec3 VW = v.subtract(w);
        if (VW.lengthSqr() == 0.0) {
            return p.distanceTo(v);
        }
        Vec3 z = v.subtract(VW.scale(v.subtract(p).dot(VW) / VW.dot(VW)));
        double dv = z.distanceToSqr(v);
        double dw = z.distanceToSqr(w);
        double dvw = v.distanceToSqr(w);
        if (dv > dvw) {
            return p.distanceTo(w);
        }
        if (dw > dvw) {
            return p.distanceTo(v);
        }
        return p.distanceTo(z);
    }
}

