/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.exchange.ImmunityExchangeSpellScroll;
import stepsword.mahoutsukai.item.spells.familiar.PossessEntitySpellScroll;
import stepsword.mahoutsukai.item.spells.mystic.DamageReplicationSpellScroll;
import stepsword.mahoutsukai.item.spells.projection.ProjectionSpellScroll;
import stepsword.mahoutsukai.item.spells.projection.ProximityProjection.ProximityProjectionKeys;
import stepsword.mahoutsukai.item.spells.projection.RealityMarbleSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.GeasSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.RetributionSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.ripper.TheRipper;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RenderSelectedEntity {
    static ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/particle/white_magic_particle1.png");
    public static Entity currentSelected = null;
    public static Entity secondSelected = null;
    public static long selectionKeyPress = 0L;

    public static void selectedEntity(Entity camera) {
        if (camera instanceof Player) {
            Player player = (Player)camera;
            HashSet<Utils.MAHOU_SELECTION> set = RenderSelectedEntity.shouldRenderSelected(player);
            if (set.size() > 0) {
                if (set.contains((Object)Utils.MAHOU_SELECTION.SELECTIVE_DISPLACEMENT) && Keybinds.selectiveDisplacement.isDown()) {
                    ++selectionKeyPress;
                    if (currentSelected == null) {
                        currentSelected = Utils.selectEntityNearCursor(player, RenderSelectedEntity.getDistance(set), player.level(), a -> Utils.getPredicate(set, a, player), Utils.nearAllowed(set));
                    } else if (selectionKeyPress > (long)MTConfig.SELECTIVE_DISPLACEMENT_HOLD_TIME) {
                        secondSelected = Utils.selectEntityNearCursor(player, RenderSelectedEntity.getDistance(set), player.level(), a -> Utils.getPredicate(set, a, player), Utils.nearAllowed(set));
                    }
                } else {
                    currentSelected = Utils.selectEntityNearCursor(player, RenderSelectedEntity.getDistance(set), player.level(), a -> Utils.getPredicate(set, a, player), Utils.nearAllowed(set));
                }
            } else {
                currentSelected = null;
                secondSelected = null;
            }
        }
    }

    public static void renderSelectedEntity(RenderLevelStageEvent event) {
        PoseStack matrix = event.getPoseStack();
        Entity camera = Minecraft.getInstance().getCameraEntity();
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        if (MTConfig.SHOW_SELECTED_ENTITY && camera instanceof Player) {
            Player player = (Player)camera;
            if (currentSelected != null && !currentSelected.isInvisibleTo(player)) {
                RenderSelectedEntity.renderSelection(matrix, buffer, partialTicks, currentSelected, player);
            }
            if (secondSelected != null && !secondSelected.isInvisibleTo(player)) {
                RenderSelectedEntity.renderSelection(matrix, buffer, partialTicks, secondSelected, player);
            }
        }
    }

    public static void renderSelection(PoseStack matrix, MultiBufferSource.BufferSource buffer, float partialTicks, Entity e, Player player) {
        Vec3 proj = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        double d3 = proj.x;
        double d4 = proj.y;
        double d5 = proj.z;
        Vec3 center = e.getBoundingBox().getCenter();
        Vec3 diff = center.subtract(e.position());
        Vec3 prev = new Vec3(e.xo, e.yo, e.zo);
        prev = prev.add(diff);
        double d0 = prev.x + (center.x - prev.x) * (double)partialTicks;
        double d1 = prev.y + (center.y - prev.y) * (double)partialTicks;
        double d2 = prev.z + (center.z - prev.z) * (double)partialTicks;
        matrix.pushPose();
        matrix.translate(d0 - d3, d1 - d4, d2 - d5);
        if (player != null) {
            float yaw = player.yRotO + (player.yRot - player.yRotO) * partialTicks;
            float pitch = player.xRotO + (player.xRot - player.xRotO) * partialTicks;
            RenderUtils.rotateQ(360.0f - yaw, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(pitch + 90.0f, 1.0f, 0.0f, 0.0f, matrix);
            matrix.scale(0.5f, 0.5f, 0.5f);
            int space = 20;
            int separators = 4;
            int degrees = 360 / separators;
            RenderUtils.rotateQ(player.level().getGameTime() % 360L * 2L, 0.0f, 1.0f, 0.0f, matrix);
            for (int i = 1; i < separators + 1; ++i) {
                RenderUtils.rotateQ(degrees, 0.0f, 1.0f, 0.0f, matrix);
                RenderType type = MahoujinRenderType.wrapNoDepthLayer(MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesNoDepthRenderType(RenderUtils.beam, 0)));
                RenderSelectedEntity.renderArc(matrix, buffer, 0.0, 0.0f, 1.0f, 0.16f, 128, 240, 240, 1.0f, 0.8f, 0.7f, 0.6f, type, degrees - space, 0.0f);
                RenderUtils.conditionalBatchEnder(type, (MultiBufferSource)buffer);
                type = MahoujinRenderType.wrapNoDepthLayer(MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesNoDepthRenderType(RenderUtils.beam, 0)));
                RenderSelectedEntity.renderArc(matrix, buffer, 0.0, 0.0f, 1.0f, 0.12f, 128, 240, 240, 1.0f, 1.0f, 1.0f, 1.0f, type, degrees - space, 0.0f);
                RenderUtils.conditionalBatchEnder(type, (MultiBufferSource)buffer);
            }
        }
        matrix.popPose();
    }

    public static HashSet<Utils.MAHOU_SELECTION> shouldRenderSelected(Player player) {
        int slot;
        ComponentItemHandler inventory;
        ItemStack mainhand = player.getMainHandItem();
        Item item = mainhand.getItem();
        Item item2 = player.getOffhandItem().getItem();
        Item item3 = null;
        if (mainhand.getItem() instanceof MysticCode && (inventory = Utils.getMCInventory(mainhand)) != null && (slot = MysticCode.getSlot(mainhand)) >= 0 && slot < 3) {
            ItemStack ammo = inventory.getStackInSlot(slot);
            item3 = ammo.getItem();
        }
        HashSet<Utils.MAHOU_SELECTION> set = RenderSelectedEntity.shouldRenderSelected(player, item);
        set.addAll(RenderSelectedEntity.shouldRenderSelected(player, item2));
        set.addAll(RenderSelectedEntity.shouldRenderSelected(player, item3));
        return set;
    }

    public static HashSet<Utils.MAHOU_SELECTION> shouldRenderSelected(Player player, Item item) {
        HashSet<Utils.MAHOU_SELECTION> set = new HashSet<Utils.MAHOU_SELECTION>();
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT) && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT_COOLDOWN)) {
            set.add(Utils.MAHOU_SELECTION.SELECTIVE_DISPLACEMENT);
        }
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.INSIGHT)) {
            set.add(Utils.MAHOU_SELECTION.INSIGHT);
        }
        if (item instanceof ProjectionSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_PROJECTION);
        }
        if (item instanceof RetributionSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_RETRIBUTION);
        }
        if (item instanceof ImmunityExchangeSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_IMMUNITY_EXCHANGE);
        }
        if (item instanceof PossessEntitySpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_POSSESS_ENTITY);
        }
        if (item instanceof DamageReplicationSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_DAMAGE_REPLICATION);
        }
        if (item instanceof GeasSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_GEAS);
        }
        if (item instanceof RealityMarbleSpellScroll) {
            set.add(Utils.MAHOU_SELECTION.SCROLL_REALITY_MARBLE);
        }
        if (item instanceof TheRipper) {
            set.add(Utils.MAHOU_SELECTION.RIPPER_FOG);
        }
        if (item instanceof ProximityProjectionKeys) {
            set.add(Utils.MAHOU_SELECTION.WEAPON);
        }
        return set;
    }

    public static int getDistance(HashSet<Utils.MAHOU_SELECTION> set) {
        if (set.contains((Object)Utils.MAHOU_SELECTION.SELECTIVE_DISPLACEMENT)) {
            return MTConfig.SELECTIVE_DISPLACEMENT_RANGE;
        }
        return MTConfig.GLOBAL_LOOK_RANGE;
    }

    public static RenderType renderArc(PoseStack matrix, MultiBufferSource.BufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type, float arcfinish, float anglestart) {
        matrix.pushPose();
        Matrix4f positionMatrix = matrix.last().pose();
        VertexConsumer bb = buffer.getBuffer(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double stop = EffectUtil.toRad(arcfinish);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float circle_b = 0.0f;
        float squeeze = 3.0f;
        float texx = 0.0f;
        for (int i = 0; i < num_segments + 1; ++i) {
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.addVertex(positionMatrix, (float)x, (float)y, (float)z).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lx, ly);
                bb.addVertex(positionMatrix, (float)xb, (float)yb, (float)zb).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lx, ly);
            }
            double tt = (double)i * theta;
            x = (double)(-radius) * Math.sin(tt);
            y = cy;
            z = (double)radius * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q;
            zb = p * Math.cos(tt);
            bb.addVertex(positionMatrix, (float)x, (float)y, (float)z).setColor(r, g, b, a).setUv(texx, 0.0f).setUv2(lx, ly);
            bb.addVertex(positionMatrix, (float)xb, (float)yb, (float)zb).setColor(r, g, b, a).setUv(texx, 1.0f).setUv2(lx, ly);
            if (tt > stop) break;
        }
        buffer.endBatch(type);
        matrix.popPose();
        return type;
    }
}

