/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.gui.MahoujinHUD;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.circuits.ManaCircuitTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MahouGui
implements LayeredDraw.Layer {
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        MahouGui.manaText(guiGraphics);
    }

    public static void manaText(GuiGraphics graphics) {
        PoseStack matrix = graphics.pose();
        Font fr = Minecraft.getInstance().font;
        String preText = "Mahou";
        int color = 0xDDDDFF;
        matrix.pushPose();
        matrix.translate(0.0f, 0.0f, -999.0f);
        IMahou mahou = Utils.getPlayerMahou((Player)Minecraft.getInstance().player);
        if (mahou != null && mahou.hasMagic() && mahou.getVisible()) {
            int storedMana = mahou.getStoredMana();
            int maxMana = mahou.getMaxMana();
            graphics.drawString(fr, preText + " " + storedMana + " / " + maxMana, MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y, color);
            MahouGui.infoOverlay(graphics, mahou, 0, fr, color);
        }
        MahouGui.circuitOverlay(graphics, fr, preText, color);
        MahouGui.projectorOverlay(graphics, fr);
        matrix.popPose();
    }

    public static void infoOverlay(GuiGraphics graphics, IMahou mahou, int dist, Font fr, int color) {
        if (mahou.getDeathCollectionUsesLeft() > 0.0f) {
            String souls = I18n.get((String)"mahoutsukai.souls.collected", (Object[])new Object[0]);
            String drain = I18n.get((String)"mahoutsukai.souls.drain", (Object[])new Object[0]);
            double mdrain = (double)mahou.getDeathCollectionUsesLeft() * MTConfig.DEATH_COLLECTION_DRAIN_PER_SOUL;
            String manadrain = String.format("%.2f", mdrain);
            graphics.drawString(fr, souls + " " + mahou.getDeathCollectionUsesLeft() + " (-" + manadrain + " " + drain + ")", MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y + (dist += 12), color);
        }
        if (mahou.getDamageExchangeUses() > 0) {
            String damageExchange = I18n.get((String)"mahoutsukai.damage_exchange.count", (Object[])new Object[0]);
            graphics.drawString(fr, damageExchange + " " + mahou.getDamageExchangeUses(), MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y + (dist += 12), color);
        }
        if (mahou.getImmunityDamageType() != null && EffectUtil.hasBuff((LivingEntity)Minecraft.getInstance().player, ModEffects.IMMUNITY_EXCHANGE)) {
            String immunityExchange = I18n.get((String)"mahoutsukai.immunity_exchange.last", (Object[])new Object[0]);
            graphics.drawString(fr, immunityExchange + " " + mahou.getImmunityDamageType(), MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_X, MTConfig.CLIENT_GUI_MAHOU_PLACEMENT_Y + (dist += 12), color);
        }
    }

    public static void mahoujinOverlay(GuiGraphics graphics) {
        MahoujinTileEntity mte;
        BlockEntity te;
        BlockHitResult bresult;
        BlockPos pos;
        LocalPlayer player = Minecraft.getInstance().player;
        HitResult result = Minecraft.getInstance().hitResult;
        if (result != null && player != null && result.getType() == HitResult.Type.BLOCK && (pos = (bresult = (BlockHitResult)result).getBlockPos()) != null && (te = player.level().getBlockEntity(pos)) instanceof MahoujinTileEntity && ((mte = (MahoujinTileEntity)te).getCatalysts() == null || mte.getCatalysts().size() == 0) && player.getMainHandItem().isEmpty()) {
            MahoujinHUD.renderHUD(graphics, Minecraft.getInstance());
        }
    }

    public static void circuitOverlay(GuiGraphics graphics, Font fr, String preText, int color) {
        BlockEntity te;
        BlockHitResult bresult;
        BlockPos pos;
        LocalPlayer player = Minecraft.getInstance().player;
        HitResult result = Minecraft.getInstance().hitResult;
        if (result != null && player != null && result.getType() == HitResult.Type.BLOCK && (pos = (bresult = (BlockHitResult)result).getBlockPos()) != null && (te = player.level().getBlockEntity(pos)) instanceof ManaCircuitTileEntity) {
            String s;
            ManaCircuitTileEntity mte = (ManaCircuitTileEntity)te;
            int xc = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2;
            int yc = Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 + 8;
            if (mte.isRedstoneOn()) {
                s = Component.translatable((String)"mahoutsukai.circuit.poweredon").getString();
                graphics.drawString(fr, s, xc - 30, yc, color);
            } else {
                s = Component.translatable((String)"mahoutsukai.circuit.poweredoff").getString();
                graphics.drawString(fr, s, xc - 30, yc, color);
            }
            graphics.drawString(fr, preText + " " + mte.getMana() + " / " + mte.getMaxMana(), xc - 30, yc + 14, color);
            if (player.getUUID().equals(mte.getOwnerUUID())) {
                s = Component.translatable((String)"mahoutsukai.circuit.yours").getString();
                graphics.drawString(fr, s, xc - 30, yc + 28, color);
            } else {
                s = Component.translatable((String)"mahoutsukai.circuit.notyours").getString();
                graphics.drawString(fr, s, xc - 30, yc + 28, color);
            }
            if (mte.getFae()) {
                s = Component.translatable((String)"mahoutsukai.circuit.fae_open").getString();
                graphics.drawString(fr, s, xc - 30, yc + 42, color);
            } else {
                s = Component.translatable((String)"mahoutsukai.circuit.fae_closed").getString();
                graphics.drawString(fr, s, xc - 30, yc + 42, color);
            }
        }
    }

    public static void projectorOverlay(GuiGraphics graphics, Font fr) {
        BlockEntity te;
        BlockHitResult bresult;
        BlockPos pos;
        LocalPlayer player = Minecraft.getInstance().player;
        HitResult result = Minecraft.getInstance().hitResult;
        int active = 0xDDDDFF;
        int inactive = 0x444466;
        if (result != null && player != null && result.getType() == HitResult.Type.BLOCK && (pos = (bresult = (BlockHitResult)result).getBlockPos()) != null && (te = player.level().getBlockEntity(pos)) instanceof MahoujinProjectorTileEntity && player.getMainHandItem().getItem() instanceof ArmorItem) {
            int xc = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2;
            int yc = Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 + 8;
            String s = Component.translatable((String)"mahoutsukai.projector_overlay.armor_replace").getString();
            Object s2 = Component.translatable((String)"mahoutsukai.projector_overlay.armor_add").getString();
            Object s3 = Component.translatable((String)"mahoutsukai.projector_overlay.armor_remove").getString();
            s2 = "[" + Keybinds.changeMysticCode.getTranslatedKeyMessage().getString().toUpperCase() + "]" + (String)s2;
            s3 = "[" + Keybinds.drawMahoujin.getTranslatedKeyMessage().getString().toUpperCase() + "]" + (String)s3;
            graphics.drawString(fr, s, xc - 30, yc + 14, active);
            graphics.drawString(fr, (String)s2, xc - 30, yc + 28, Keybinds.changeMysticCode.isDown() ? active : inactive);
            graphics.drawString(fr, (String)s3, xc - 30, yc + 42, !Keybinds.changeMysticCode.isDown() && Keybinds.drawMahoujin.isDown() ? active : inactive);
        }
    }
}

