/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.entity.mahoujin.SpatialDisorientationMahoujinEntity;
import stepsword.mahoutsukai.proxy.ClientProxy;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderSpatialDisorientationMahoujinEntity
extends EntityRenderer<SpatialDisorientationMahoujinEntity> {
    private static final ResourceLocation mahoujin = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/mahoujin_casting.png");

    public RenderSpatialDisorientationMahoujinEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(SpatialDisorientationMahoujinEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderSpatial(SpatialDisorientationMahoujinEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float prevYaw;
        matrix.pushPose();
        int life = entity.getLife();
        float size = entity.getCircleSize();
        float yaw = entity.yRot % 360.0f;
        float roll = entity.getRotationRoll();
        float pitch = entity.getRotationPitch();
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if ((prevYaw = entity.yRotO % 360.0f) < 0.0f) {
            prevYaw += 360.0f;
        }
        if (prevYaw - yaw > 300.0f) {
            yaw += 360.0f;
        }
        if (prevYaw - yaw < 300.0f && prevYaw - yaw > 0.0f) {
            prevYaw = yaw;
        }
        yaw = entity.yRotO + partialTicks * (yaw - prevYaw);
        matrix.translate(x, y, z);
        matrix.scale(size, size, size);
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSpatialDisorientationMahoujinEntity.renderAll(entity, matrix, buf);
        matrix.popPose();
    }

    public static void renderAll(SpatialDisorientationMahoujinEntity entity, PoseStack matrix, MultiBufferSource.BufferSource buffer) {
        RenderType type = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, true));
        VertexConsumer bb = buffer.getBuffer(type);
        Matrix4f m = matrix.last().pose();
        int lightmapX = 240;
        int lightmapY = 240;
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        bb.addVertex(m, -0.5f, 0.0f, -0.5f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, -0.5f, 0.0f, 0.5f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f, 0.0f, 0.5f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f, 0.0f, -0.5f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
        buffer.endBatch(type);
        double cy = -1.5;
        float f = 0.0f;
        float rad = 0.8f;
        float h = 0.125f;
        int segments = 128;
        int index = 0;
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy, f, rad, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy, f, rad * 2.0f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy += 0.3, f += 20.0f, rad -= 0.2f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy, f, rad * 2.0f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy += 0.3, f += 20.0f, rad -= 0.2f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy, f, rad * 2.0f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy += 0.3, f += 20.0f, rad -= 0.2f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy, f, rad * 2.0f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        cy = 0.0;
        f = 0.0f;
        rad = 0.7f;
        h = 0.125f;
        segments = 128;
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy, f, rad, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy += 0.3, f += 20.0f, rad -= 0.15f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy += 0.3, f += 20.0f, rad -= 0.15f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy += 0.3, f += 20.0f, rad -= 0.15f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy += 0.4, f += 15.0f, rad -= 0.15f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy += 0.5, f += 10.0f, rad -= 0.05f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
        buffer.endBatch(RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, cy += 0.6, f += 5.0f, rad -= 0.02f, h, segments, lightmapX, lightmapY, r, g, b, a, index++));
    }

    public ResourceLocation getTextureLocation(SpatialDisorientationMahoujinEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public static void spatialRender(Entity re, PoseStack matrix, float partialTicks) {
        Vec3 proj = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        double d3 = proj.x;
        double d4 = proj.y;
        double d5 = proj.z;
        HashSet<Entity> entities = ClientProxy.getAllEntities(Minecraft.getInstance().level);
        if (entities != null && entities.size() > 0) {
            for (Entity entity : entities) {
                if (!(entity instanceof SpatialDisorientationMahoujinEntity) || !(entity.distanceToSqr(re) < 16384.0)) continue;
                SpatialDisorientationMahoujinEntity beam = (SpatialDisorientationMahoujinEntity)entity;
                double d0 = beam.xo + (beam.getX() - beam.xo) * (double)partialTicks;
                double d1 = beam.yo + (beam.getY() - beam.yo) * (double)partialTicks;
                double d2 = beam.zo + (beam.getZ() - beam.zo) * (double)partialTicks;
                float m = beam.yRotO + (beam.yRot - beam.yRotO) * partialTicks;
                RenderSpatialDisorientationMahoujinEntity.renderSpatial((SpatialDisorientationMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
            }
        }
    }
}

