/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderMysticStaffBeamMahoujinEntity
extends EntityRenderer<MysticStaffBeamMahoujinEntity> {
    private static final ResourceLocation mahoujin = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/mahoujin_casting.png");
    private static final ResourceLocation beam = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/white.png");
    private static final ResourceLocation beam_start = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/particles/white-circle.png");

    public RenderMysticStaffBeamMahoujinEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(MysticStaffBeamMahoujinEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(MysticStaffBeamMahoujinEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderBeam(MysticStaffBeamMahoujinEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float m;
        float beam_len = entity.prev_beam_len + (entity.getBeamLength() - entity.prev_beam_len) * partialTicks;
        float beam_size = entity.prev_beam_size + (entity.getBeamSize() - entity.prev_beam_size) * partialTicks;
        float mini_speed = entity.getRotationSpeed();
        float mini_roll = entity.getRotationRoll();
        float sphere_size = entity.prev_sphere_size + (entity.getSphereSize() - entity.prev_sphere_size) * partialTicks;
        float size = entity.getCircleSize();
        entity.yRotO %= 360.0f;
        if (entity.yRotO < 0.0f) {
            entity.yRotO += 360.0f;
        }
        if (entity.yRotO > 360.0f) {
            entity.yRotO -= 360.0f;
        }
        if ((m = entity.getRotationYaw() - entity.yRotO) > 180.0f) {
            m -= 360.0f;
        }
        if (m < -180.0f) {
            m += 360.0f;
        }
        float yaw = entity.yRotO + m * partialTicks;
        float pitch = entity.xRotO + (entity.getRotationPitch() - entity.xRotO) * partialTicks;
        matrix.pushPose();
        matrix.translate(x, y, z);
        matrix.scale(size, size, size);
        float[] colors = entity.getColor();
        float outeralpha = 0.3f;
        float beam_y_off = -0.7f;
        int lightmapX = 240;
        int lightmapY = 240;
        float smallsize = size * 0.25f;
        int smallcircles = 6;
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        RenderMysticStaffBeamMahoujinEntity.rotate(0.0f, pitch, yaw, matrix);
        RenderMysticStaffBeamMahoujinEntity.circleRender(lightmapX, lightmapY, r, g, b, a, smallcircles + 1, matrix);
        RenderMysticStaffBeamMahoujinEntity.unrotate(0.0f, pitch, yaw, matrix);
        RenderMysticStaffBeamMahoujinEntity.rotate(entity.prev_mini_roll + partialTicks * (mini_roll - entity.prev_mini_roll), pitch, yaw, matrix);
        for (int i = 0; i < smallcircles; ++i) {
            if (entity.getDying() >= MysticStaffBeamMahoujinEntity.dyingticks + i * 2 || entity.getLife() <= i * 2) continue;
            float angle = 360.0f / (float)smallcircles;
            RenderUtils.rotateQ(angle, 0.0f, 1.0f, 0.0f, matrix);
            matrix.translate(0.8f, 0.0f, 0.0f);
            matrix.scale(smallsize / size, smallsize / size, smallsize / size);
            RenderMysticStaffBeamMahoujinEntity.circleRender(lightmapX, lightmapY, r, g, b, a, i, matrix);
            matrix.scale(size / smallsize, size / smallsize, size / smallsize);
            matrix.translate(-0.8f, 0.0f, 0.0f);
        }
        RenderMysticStaffBeamMahoujinEntity.unrotate(mini_roll - mini_speed + partialTicks * mini_speed, pitch, yaw, matrix);
        RenderMysticStaffBeamMahoujinEntity.rotate(0.0f, pitch, yaw, matrix);
        matrix.translate(0.0f, beam_y_off, 0.0f);
        RenderType beamtype1 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createBeamRenderType(beam, 0));
        RenderType beamtype2 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createBeamRenderType(beam, 1));
        RenderType spheretype1 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(beam, 2));
        RenderType spheretype2 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(beam, 3));
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, Math.max(sphere_size - 0.1f, 0.0f), 20, lightmapX, lightmapY, 1.0f, 1.0f, 1.0f, 0.99f, spheretype1);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, Math.max(0.0f, beam_size - 0.1f), beam_len, 64, lightmapX, lightmapY, 1.0f, 1.0f, 1.0f, 0.99f, beamtype1);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, beam_size, beam_len, 64, lightmapX, lightmapY, r, g, b, outeralpha, beamtype2);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, sphere_size, 20, lightmapX, lightmapY, r, g, b, outeralpha, spheretype2);
        buf.endBatch(spheretype1);
        buf.endBatch(beamtype1);
        buf.endBatch(beamtype2);
        buf.endBatch(spheretype2);
        matrix.popPose();
    }

    public static void rotate(float yaw, float pitch, float roll, PoseStack matrix) {
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
    }

    public static void unrotate(float yaw, float pitch, float roll, PoseStack matrix) {
        RenderUtils.rotateQ(-yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-roll, 0.0f, 1.0f, 0.0f, matrix);
    }

    public static void circleRender(int lightmapX, int lightmapY, float r, float g, float b, float a, int index, PoseStack matrix) {
        RenderType type = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(mahoujin, index, false));
        VertexConsumer buffer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(type);
        Matrix4f m = matrix.last().pose();
        buffer.addVertex(m, -0.5f, 0.0f, -0.5f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
        buffer.addVertex(m, -0.5f, 0.0f, 0.5f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        buffer.addVertex(m, 0.5f, 0.0f, 0.5f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        buffer.addVertex(m, 0.5f, 0.0f, -0.5f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
        Minecraft.getInstance().renderBuffers().bufferSource().endBatch(type);
    }
}

