/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.entity.fae.FaeEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderFaeEntity
extends EntityRenderer<FaeEntity> {
    public static ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/entity/fae.png");
    public static RenderType type = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(texture, 0, true));

    public RenderFaeEntity(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    @Nullable
    public ResourceLocation getTextureLocation(FaeEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(FaeEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public static void render(FaeEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        RenderFaeEntity.renderTexture(entity, x, y, z, matrix, partialTicks);
    }

    public static void renderTexture(FaeEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float[] rgb = entity.getColor();
        float r = rgb[0] / 255.0f;
        float g = rgb[1] / 255.0f;
        float b = rgb[2] / 255.0f;
        float a = 0.9f;
        float scale = 0.5f;
        Entity e = Minecraft.getInstance().getCameraEntity();
        matrix.translate(x, y, z);
        matrix.translate(0.0f, 0.5f, 0.0f);
        if (e != null) {
            float yaw = e.yRotO + (e.yRot - e.yRotO) * partialTicks;
            float pitch = e.xRotO + (e.xRot - e.xRotO) * partialTicks;
            RenderUtils.rotateQ(360.0f - yaw, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(pitch + 90.0f, 1.0f, 0.0f, 0.0f, matrix);
            int j = 240;
            int k = 240;
            float xx = 0.5f * scale;
            float bxx = -xx;
            float yy = 0.0f;
            VertexConsumer bb = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(type);
            Matrix4f m = matrix.last().pose();
            bb.addVertex(m, bxx, yy, bxx).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(j, k);
            bb.addVertex(m, bxx, yy, xx).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(j, k);
            bb.addVertex(m, xx, yy, xx).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(j, k);
            bb.addVertex(m, xx, yy, bxx).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(j, k);
            Minecraft.getInstance().renderBuffers().bufferSource().endBatch(type);
        }
    }
}

