/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.OptionalDouble;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.render.BlendWrappedRenderLayer;
import stepsword.mahoutsukai.render.BrightWrappedRenderLayer;
import stepsword.mahoutsukai.render.ClipWrappedRenderLayer;
import stepsword.mahoutsukai.render.ColorWrappedRenderLayer;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.FogRenderLayer;
import stepsword.mahoutsukai.render.GlowRenderLayer;
import stepsword.mahoutsukai.render.NoDepthWrappedRenderLayer;
import stepsword.mahoutsukai.render.shader.ModShaders;

public class MahoujinRenderType
extends RenderType {
    public static HashMap<String, RenderType> renderTypeCache = new HashMap();

    public MahoujinRenderType(String nameIn, VertexFormat formatIn, VertexFormat.Mode drawModeIn, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, Runnable setupTaskIn, Runnable clearTaskIn) {
        super(nameIn, formatIn, drawModeIn, bufferSizeIn, useDelegateIn, needsSortingIn, setupTaskIn, clearTaskIn);
    }

    public static RenderType createCachedRenderType(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, RenderType.CompositeState state) {
        if (renderTypeCache.containsKey(name)) {
            return renderTypeCache.get(name);
        }
        RenderType.CompositeRenderType cacheme = MahoujinRenderType.create((String)name, (VertexFormat)format, (VertexFormat.Mode)mode, (int)bufferSize, (boolean)affectsCrumbling, (boolean)sortOnUpload, (RenderType.CompositeState)state);
        renderTypeCache.put(name, (RenderType)cacheme);
        return cacheme;
    }

    public static RenderType createHollowSquareRenderType(ResourceLocation r, int x, boolean blur) {
        RenderType ret = MahoujinRenderType.createCachedRenderType("mahou_hollow_square" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, blur, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
        return ret;
    }

    public static RenderType createBoxRenderType(ResourceLocation r, int x) {
        return MahoujinRenderType.createCachedRenderType("mahou_box" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.TRIANGLE_STRIP, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, false, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    }

    public static RenderType createMahoujinRenderType(ResourceLocation r, int x, boolean blur) {
        RenderType ret = MahoujinRenderType.createCachedRenderType("mahou_mahoujin" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, blur, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
        return ret;
    }

    public static RenderType createMahoujinNoFogRenderType(ResourceLocation r, int x, boolean blur) {
        RenderType ret = MahoujinRenderType.createCachedRenderType("mahou_mahoujin_no_fog" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, blur, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
        return ret;
    }

    public static RenderType createShadedRenderType(ResourceLocation r, int x, boolean blur) {
        RenderType ret = MahoujinRenderType.createCachedRenderType("mahou_shaded" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).setShaderState(RENDERTYPE_SOLID_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, blur, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLightmapState(LIGHTMAP).createCompositeState(false));
        return ret;
    }

    public static RenderType createMahoujinRenderType(ResourceLocation r, int x, boolean blur, Supplier<ShaderInstance> shader) {
        RenderType ret = MahoujinRenderType.createCachedRenderType("mahou_circle" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(shader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, blur, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
        return ret;
    }

    public static RenderType createFogRenderType(ResourceLocation r, int x, boolean blur, Supplier<ShaderInstance> shader) {
        RenderType ret = MahoujinRenderType.createCachedRenderType("mahou_fog" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(shader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, blur, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
        return ret;
    }

    public static RenderType createRunesRenderType(ResourceLocation r, int x) {
        return MahoujinRenderType.createCachedRenderType("mahou_runes" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.TRIANGLE_STRIP, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, false, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    }

    public static RenderType createLightningRenderType(ResourceLocation r, int x) {
        return MahoujinRenderType.createCachedRenderType("mahou_lightning" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.TRIANGLE_STRIP, 256, true, true, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, false, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    }

    public static RenderType createRunesPRenderType(ResourceLocation r, int x) {
        return MahoujinRenderType.createCachedRenderType("mahou_runes_ley" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.TRIANGLE_STRIP, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, false, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    }

    public static RenderType createBeamRenderType(ResourceLocation r, int x) {
        return MahoujinRenderType.createCachedRenderType("mahou_beam" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.TRIANGLE_STRIP, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, false, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    }

    public static RenderType createSphereRenderType(ResourceLocation r, int x) {
        return MahoujinRenderType.createCachedRenderType("mahou_sphere" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.TRIANGLE_STRIP, 256, false, true, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, false, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    }

    public static RenderType createSphereRenderType2(ResourceLocation r, int x) {
        return MahoujinRenderType.createCachedRenderType("mahou_sphere_2" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.TRIANGLE_STRIP, 256, false, false, RenderType.CompositeState.builder().setLayeringState(VIEW_OFFSET_Z_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(() -> ModShaders.FULLBRIGHT_QUADS)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, false, false)).setDepthTestState(LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    }

    public static RenderType createLinesRenderType(double width, int index) {
        return MahoujinRenderType.createCachedRenderType("mahou_lines" + index, DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, 256, false, false, RenderType.CompositeState.builder().setLayeringState(VIEW_OFFSET_Z_LAYERING).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(width))).setShaderState(RENDERTYPE_LINES_SHADER).setTextureState(RenderStateShard.NO_TEXTURE).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).setCullState(NO_CULL).setWriteMaskState(RenderStateShard.COLOR_WRITE).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    }

    public static RenderType createTriangleRenderType(ResourceLocation r, int x) {
        return MahoujinRenderType.createCachedRenderType("mahou_triangle" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.TRIANGLES, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, false, false)).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    }

    public static RenderType createRunesNoDepthRenderType(ResourceLocation r, int x) {
        return MahoujinRenderType.createCachedRenderType("mahou_runes_no_depth" + r.getPath() + x, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.TRIANGLE_STRIP, 256, false, false, RenderType.CompositeState.builder().setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionColorTexLightmapShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(r, false, false)).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).createCompositeState(false));
    }

    public static RenderType checkCached(RenderType type) {
        if (renderTypeCache.containsKey(type.name)) {
            return renderTypeCache.get(type.name);
        }
        renderTypeCache.put(type.name, type);
        return type;
    }

    public static RenderType checkCached(String name, Supplier<RenderType> sup) {
        if (renderTypeCache.containsKey(name)) {
            return renderTypeCache.get(name);
        }
        RenderType type = sup.get();
        renderTypeCache.put(type.name, type);
        return type;
    }

    public static RenderType wrapGlowLayer(RenderType type, float[] rgba, float softness, boolean shaders) {
        return new GlowRenderLayer(type, rgba, softness, shaders);
    }

    public static RenderType wrapFogLayer(RenderType type, float[] rgba, float softness) {
        return new FogRenderLayer(type, rgba, softness);
    }

    public static RenderType wrapCullLayer(RenderType type) {
        return MahoujinRenderType.checkCached(CullWrappedRenderLayer.getWouldBeName(type), () -> new CullWrappedRenderLayer(type));
    }

    public static RenderType wrapBlendLayer(RenderType type) {
        return MahoujinRenderType.checkCached(BlendWrappedRenderLayer.getWouldBeName(type), () -> new BlendWrappedRenderLayer(type));
    }

    public static RenderType wrapBrightLayer(RenderType type) {
        return MahoujinRenderType.checkCached(BrightWrappedRenderLayer.getWouldBeName(type), () -> new BrightWrappedRenderLayer(type));
    }

    public static RenderType wrapColorLayer(RenderType type, float r, float g, float b, float a) {
        return new ColorWrappedRenderLayer(type, r, g, b, a);
    }

    public static RenderType wrapClipLayer(RenderType type, boolean flag, double pitch, double yaw, double x, double y, double z, double p, double size, Matrix4f m) {
        return new ClipWrappedRenderLayer(flag, pitch, yaw, x, y, z, p, size, type, m);
    }

    public static RenderType wrapNoDepthLayer(RenderType type) {
        return MahoujinRenderType.checkCached(NoDepthWrappedRenderLayer.getWouldBeName(type), () -> new NoDepthWrappedRenderLayer(type));
    }
}

