/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.item.replica.Replica;
import stepsword.mahoutsukai.networking.MahouPackets;

public class ReplicaSwitchPacket
implements CustomPacketPayload {
    int slot;
    public static final StreamCodec<ByteBuf, ReplicaSwitchPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.slot, ReplicaSwitchPacket::new);

    public ReplicaSwitchPacket(int s) {
        this.slot = s;
    }

    public static void handle(ReplicaSwitchPacket message, IPayloadContext context) {
        ReplicaSwitchPacket.handleReplicaSwitch(message, context.player());
    }

    public static void handleReplicaSwitch(ReplicaSwitchPacket message, Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack != null && !stack.isEmpty() && stack.getItem() instanceof Replica) {
            if (message.slot == 6) {
                Replica.clearDamageTypes(stack);
            } else {
                Replica.setSelectedSlot(stack, message.slot);
            }
        }
    }

    public CustomPacketPayload.Type<ReplicaSwitchPacket> type() {
        return MahouPackets.REPLICA_SWITCH_TYPE;
    }
}

