/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.sword.SwordMahou;
import stepsword.mahoutsukai.entity.SmiteEntity;
import stepsword.mahoutsukai.entity.mahoujin.ReplicaTeleportMahoujinEntity;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.item.replica.Replica;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RagePotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ItemAbilityPacket
implements CustomPacketPayload {
    ABILITY ability;
    public static final StreamCodec<ByteBuf, ItemAbilityPacket> STREAM_CODEC = new StreamCodec<ByteBuf, ItemAbilityPacket>(){

        public ItemAbilityPacket decode(ByteBuf buf) {
            ItemAbilityPacket packet = new ItemAbilityPacket();
            packet.decode(buf);
            return packet;
        }

        public void encode(ByteBuf buf, ItemAbilityPacket packet) {
            packet.encode(buf);
        }
    };

    public ItemAbilityPacket() {
    }

    public ItemAbilityPacket(ABILITY a) {
        this.ability = a;
    }

    public void decode(ByteBuf buf) {
        int n = buf.readInt();
        this.ability = n < ABILITY.values().length ? ABILITY.values()[n] : ABILITY.CALIBURN;
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.ability.ordinal());
    }

    public static void handle(ItemAbilityPacket message, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (message.ability == ABILITY.CALIBURN) {
                ItemAbilityPacket.handleAbilityCaliburn(player2);
            } else if (message.ability == ABILITY.MORGAN) {
                ItemAbilityPacket.handleAbilityMorgan(player2);
            } else if (message.ability == ABILITY.REPLICA) {
                ItemAbilityPacket.handleAbilityReplica(player2);
            }
        }
    }

    public static void handleAbilityCaliburn(ServerPlayer player) {
        int radius = MTConfig.POWER_CONSOLIDATION_SMITE_RADIUS;
        AABB aabb = new AABB(player.position().add((double)(-radius), (double)(-radius / 2), (double)(-radius)), player.position().add((double)radius, (double)(radius / 2), (double)radius));
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof Caliburn) {
            if (!EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN)) {
                if (PlayerManaManager.drainMana((Player)player, MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST, false, false) == MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST) {
                    SwordMahou mahou = Utils.getSwordMahou(stack);
                    Utils.setSwordMahou(stack, mahou);
                    int targets = 0;
                    List lst = player.level().getEntitiesOfClass(LivingEntity.class, aabb);
                    for (LivingEntity target : lst) {
                        if (target.getUUID().equals(player.getUUID()) || !Caliburn.specialTarget(target)) continue;
                        ++targets;
                    }
                    boolean hit = false;
                    for (LivingEntity target : lst) {
                        if (target.getUUID().equals(player.getUUID()) || !Caliburn.specialTarget(target)) continue;
                        SmiteEntity smite = new SmiteEntity(target.level(), target, 0.9019608f, 0.9019608f, 0.16470589f, 1.0f, 0.1f, mahou.getAttackDamage() / (float)targets);
                        smite.setPos(target.getX(), target.getY(), target.getZ());
                        hit = true;
                        target.level().addFreshEntity((Entity)smite);
                    }
                    if (hit) {
                        EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
                    }
                }
            } else {
                ItemAbilityPacket.cooldownMessage((Player)player, player.getEffect(ModEffects.CM_COOLDOWN).getDuration());
            }
        }
    }

    public static void handleAbilityMorgan(ServerPlayer player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof Morgan) {
            if (!EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN)) {
                EffectUtil.buff((LivingEntity)player, ModEffects.RAGE, false, MTConfig.MORGAN_RAGE_TIME);
                RagePotion.notifyIfRage((LivingEntity)player);
                EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
            } else {
                ItemAbilityPacket.cooldownMessage((Player)player, player.getEffect(ModEffects.CM_COOLDOWN).getDuration());
            }
        }
    }

    public static void handleAbilityReplica(ServerPlayer player) {
        if (player.getUseItem().getItem() instanceof Replica) {
            if (!EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN)) {
                Vec3 teleport = Replica.getTeleportLocation(player.getUseItem());
                ResourceLocation dim = Replica.getTeleportDimension(player.getUseItem());
                if (dim == null) {
                    dim = Level.OVERWORLD.location();
                }
                if (teleport != null) {
                    boolean allowed = true;
                    if (MTConfig.REPLICA_TELEPORT_MAX_DISTANCE > 0.0 && teleport.distanceToSqr(player.position()) > MTConfig.REPLICA_TELEPORT_MAX_DISTANCE * MTConfig.REPLICA_TELEPORT_MAX_DISTANCE) {
                        allowed = false;
                    }
                    if (!MTConfig.REPLICA_TELEPORT_CROSS_DIMENSION && !dim.equals((Object)EffectUtil.getDimension(player.level()))) {
                        allowed = false;
                    }
                    if (allowed && PlayerManaManager.drainMana((Player)player, MTConfig.REPLICA_TELEPORT_MANA_COST, false, false) == MTConfig.REPLICA_TELEPORT_MANA_COST) {
                        ReplicaTeleportMahoujinEntity repte = new ReplicaTeleportMahoujinEntity(player.level(), (LivingEntity)player, 0.24f, 0.94f, 1.0f, 0.8f, dim, teleport, true);
                        repte.setPos(player.getX(), player.getY() + 0.005, player.getZ());
                        player.level().addFreshEntity((Entity)repte);
                        ReplicaTeleportMahoujinEntity repte2 = new ReplicaTeleportMahoujinEntity(player.level(), (LivingEntity)player, 0.24f, 0.94f, 1.0f, 0.8f, dim, teleport, true, false);
                        repte2.setPos(teleport.x, teleport.y + 0.005, teleport.z);
                        player.level().addFreshEntity((Entity)repte2);
                        EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
                    }
                }
            } else {
                ItemAbilityPacket.cooldownMessage((Player)player, player.getEffect(ModEffects.CM_COOLDOWN).getDuration());
            }
        }
    }

    public static void cooldownMessage(Player player, int seconds) {
        player.displayClientMessage((Component)Component.translatable((String)"mahoutsukai.help.ability_cooldown").append(" " + seconds / 20), true);
    }

    public CustomPacketPayload.Type<ItemAbilityPacket> type() {
        return MahouPackets.ITEM_ABILITY_TYPE;
    }

    public static enum ABILITY {
        MORGAN,
        CALIBURN,
        REPLICA;

    }
}

