/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.chunks.IChunkMahou;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.dataattachments.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.networking.ActingPacket;
import stepsword.mahoutsukai.networking.AuthorityPacket;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.BeamPacket;
import stepsword.mahoutsukai.networking.BlackFirePacket;
import stepsword.mahoutsukai.networking.ChunkMahouPacket;
import stepsword.mahoutsukai.networking.DataManagerPacket;
import stepsword.mahoutsukai.networking.EntityPathPacket;
import stepsword.mahoutsukai.networking.FaeNoisePacket;
import stepsword.mahoutsukai.networking.FogPacket;
import stepsword.mahoutsukai.networking.GardenPacket;
import stepsword.mahoutsukai.networking.InsightPacket;
import stepsword.mahoutsukai.networking.MagicCircleBoomParticlePacket;
import stepsword.mahoutsukai.networking.PlayerMahouPacket;
import stepsword.mahoutsukai.networking.PossessEntityPacket;
import stepsword.mahoutsukai.networking.RagePacket;
import stepsword.mahoutsukai.networking.ReplicaKnockbackParticlePacket;
import stepsword.mahoutsukai.networking.RevertedPacket;
import stepsword.mahoutsukai.networking.RipperInvisiblePacket;
import stepsword.mahoutsukai.networking.ScryingEntityPacket;
import stepsword.mahoutsukai.networking.SettingsMahouPacket;
import stepsword.mahoutsukai.potion.ClairvoyanceEyesPotion;
import stepsword.mahoutsukai.potion.InsightEyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ReversionEyesPotion;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.overlay.RenderInsightOverlay;
import stepsword.mahoutsukai.render.particle.ModParticles;
import stepsword.mahoutsukai.render.particle.ParticleMagic;
import stepsword.mahoutsukai.render.particle.ParticleSphere;
import stepsword.mahoutsukai.render.particle.ParticleSphereExplosion;
import stepsword.mahoutsukai.sounds.BeamMovingSound;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ClientPacketHandler {
    public static void mahouPacketHandler(PlayerMahouPacket message) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null) {
            IMahou mahou = Utils.getPlayerMahou((Player)player);
            IMahou mahouUpdate = message.mahou;
            if (mahou != null) {
                mahou.copyMahou(mahouUpdate);
            }
        }
    }

    public static void mahouPacketHandler(SettingsMahouPacket message) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null) {
            ISettingsMahou mahou = Utils.getSettingsMahou((LivingEntity)player);
            ISettingsMahou mahouUpdate = message.mahou;
            if (mahou != null) {
                mahou.copyMahou(mahouUpdate);
            }
        }
    }

    public static void chunkMahouPacketHandler(ChunkMahouPacket message) {
        Minecraft mc = Minecraft.getInstance();
        LevelChunk c = Minecraft.getInstance().level.getChunk(message.x, message.z);
        IChunkMahou chunkMahou = Utils.getChunkMahou(c);
        if (chunkMahou != null) {
            if (message.mode == 0) {
                chunkMahou.setLakeBlocks(message.set);
            }
            if (message.mode == 1) {
                chunkMahou.setFogProjectors(message.set);
            }
        }
    }

    public static void updateTE(DataManagerPacket message) {
        Minecraft mc = Minecraft.getInstance();
        BlockEntity te = mc.level.getBlockEntity(message.pos);
        if (te instanceof ScryingMahoujinTileEntity) {
            ((ScryingMahoujinTileEntity)te).scryDataManager = message.dataManagerEntries;
        }
    }

    public static void updateFire(BlackFirePacket message) {
        Entity e = Minecraft.getInstance().level.getEntity(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.onFire) {
                EffectUtil.buff((LivingEntity)e, ModEffects.BLACK_BURNING, false, 180);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.BLACK_BURNING);
            }
        }
    }

    public static void pathHandler(EntityPathPacket message) {
        try {
            if (ClairvoyanceEyesPotion.predictionMap == null) {
                ClairvoyanceEyesPotion.predictionMap = new ConcurrentHashMap();
            }
            Minecraft mc = Minecraft.getInstance();
            int range = MTConfig.CLAIRVOYANCE_RANGE;
            LocalPlayer player = mc.player;
            AABB aabb = new AABB(player.blockPosition().offset(-range, -range, -range).getCenter(), player.blockPosition().offset(range, range, range).getCenter());
            List lst = mc.level.getEntitiesOfClass(PathfinderMob.class, aabb);
            HashSet nearby = new HashSet(lst);
            HashSet<PathfinderMob> received = new HashSet<PathfinderMob>();
            for (int i = 0; i < message.entities.size(); ++i) {
                Entity e = player.level().getEntity(message.entities.get(i).intValue());
                if (!(e instanceof PathfinderMob)) continue;
                PathfinderMob living = (PathfinderMob)e;
                received.add(living);
                if (!nearby.contains(living) || i >= message.paths.size()) continue;
                Path path = message.paths.get(i);
                if (ClairvoyanceEyesPotion.predictionMap == null) continue;
                if (ClairvoyanceEyesPotion.predictionMap.containsKey(living)) {
                    Path p = ClairvoyanceEyesPotion.predictionMap.get(living);
                    if (p.getNode(p.getNodeCount() - 1).equals((Object)path.getNode(path.getNodeCount() - 1))) continue;
                    ClairvoyanceEyesPotion.predictionMap.put(living, path);
                    continue;
                }
                ClairvoyanceEyesPotion.predictionMap.put(living, path);
            }
            if (ClairvoyanceEyesPotion.predictionMap != null) {
                for (Entity e : ClairvoyanceEyesPotion.predictionMap.keySet()) {
                    if (nearby.contains(e) && received.contains(e)) continue;
                    ClairvoyanceEyesPotion.predictionMap.remove(e);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateReverted(RevertedPacket message) {
        Entity e = Minecraft.getInstance().level.getEntity(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.reverted) {
                ReversionEyesPotion.setEntityReverted((LivingEntity)e);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.REVERTED);
            }
        }
    }

    public static void gardenHandler(GardenPacket message) {
        FamiliarEntity.gardenEffectB(Utils.toBlockPos(message.posX, message.posY, message.posZ), (Level)Minecraft.getInstance().level);
    }

    public static void scryingHandler(ScryingEntityPacket message) {
        BlockEntity be = Minecraft.getInstance().player.level().getBlockEntity(Utils.toBlockPos(message.posX, message.posY, message.posZ));
        if (be instanceof ScryingMahoujinTileEntity) {
            if (message.entityTag == null) {
                ((ScryingMahoujinTileEntity)be).scryTarget = null;
                ((ScryingMahoujinTileEntity)be).lst = new ArrayList();
                ((ScryingMahoujinTileEntity)be).scryNBT = null;
            }
            ((ScryingMahoujinTileEntity)be).scryNBT = message.entityTag.orElse(null);
            ((ScryingMahoujinTileEntity)be).doRead = true;
        }
    }

    public static void possess(PossessEntityPacket message) {
        try {
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            ChunkPos pos = new ChunkPos(message.chunkx, message.chunkz);
            List lst = player.level().getEntitiesOfClass(Entity.class, new AABB(new BlockPos(pos.getWorldPosition().getX(), player.level().getMinBuildHeight(), pos.getWorldPosition().getZ()).getCenter(), pos.getWorldPosition().offset(16, player.level().getMaxBuildHeight(), 16).getCenter()).inflate(10.0));
            for (Entity entity : lst) {
                if (entity.getId() != message.entityId) continue;
                mc.setCameraEntity(entity);
                IMahou mahou = Utils.getPlayerMahou((Player)player);
                if (mahou == null) continue;
                mahou.setPossessing(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleBakuretsu(BakuretsuPacket message) {
        LocalPlayer player = Minecraft.getInstance().player;
        Bakuretsu bakuretsu = new Bakuretsu(message.strength, (float)message.posX, (float)message.posY, (float)message.posZ, 0.0f);
        bakuretsu.explosionB((Level)Minecraft.getInstance().level, (Player)Minecraft.getInstance().player);
        double motionX = player.getDeltaMovement().x;
        double motionY = player.getDeltaMovement().y;
        double motionZ = player.getDeltaMovement().z;
        player.setDeltaMovement(motionX += (double)message.motionX, motionY += (double)message.motionY, motionZ += (double)message.motionZ);
    }

    public static void insightHandler(InsightPacket message, Level level) {
        RenderInsightOverlay.inventory = InsightEyesPotion.readInventory(message.inventory, level);
        RenderInsightOverlay.entityId = message.id;
        RenderInsightOverlay.hasTarget = message.hasTarget;
        RenderInsightOverlay.block = message.block;
        RenderInsightOverlay.effects = InsightEyesPotion.readEffects(message.effects);
        RenderInsightOverlay.mainhandindex = message.mainhandindex;
    }

    public static void beamHandler(BeamPacket message) {
        Entity entity;
        if (Minecraft.getInstance().level != null && (entity = Minecraft.getInstance().level.getEntity(message.entityId)) instanceof MysticStaffBeamMahoujinEntity) {
            BeamMovingSound s = new BeamMovingSound((Player)Minecraft.getInstance().player, (MysticStaffBeamMahoujinEntity)entity);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)s);
        }
    }

    public static void faeNoiseHandler(FaeNoisePacket message) {
        if (Minecraft.getInstance().level != null && MTConfig.FAE_NOISE) {
            Minecraft.getInstance().execute(() -> Minecraft.getInstance().level.playSound((Player)Minecraft.getInstance().player, (double)message.x, (double)message.y, (double)message.z, message.sound, message.cat, message.vol, message.pit));
        }
    }

    public static void updateRage(RagePacket message) {
        Entity e = Minecraft.getInstance().level.getEntity(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.rage) {
                EffectUtil.buff((LivingEntity)e, ModEffects.RAGE, false, MTConfig.MORGAN_RAGE_TIME);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.RAGE);
            }
        }
    }

    public static void updateActing(ActingPacket message) {
        Entity e = Minecraft.getInstance().level.getEntity(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.acting) {
                EffectUtil.buff((LivingEntity)e, ModEffects.RAGE, false, MTConfig.MORGAN_RAGE_TIME);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.RAGE);
            }
        }
    }

    public static void updateAuthority(AuthorityPacket message) {
        Entity e = Minecraft.getInstance().level.getEntity(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.authority) {
                EffectUtil.buff((LivingEntity)e, ModEffects.BORROWED_AUTHORITY, false, MTConfig.AUTHORITY_TIME);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.BORROWED_AUTHORITY);
            }
        }
    }

    public static void magicParticleHandler(MagicCircleBoomParticlePacket message) {
        Vec3 look = new Vec3(message.lookX, message.lookY, message.lookZ).normalize();
        Vec3 v = look.xRot(EffectUtil.toRad(90.0f)).normalize();
        for (int i = 0; i < 25; ++i) {
            float b;
            float g;
            float r;
            double angle = Math.random() * 360.0;
            if (message.boom_mode == 0) {
                v = ClientPacketHandler.rotateVecAroundVec(v, look, (float)angle);
            } else if (message.boom_mode == 1) {
                v = Vec3.directionFromRotation((float)((float)angle), (float)((float)Math.random() * 360.0f)).normalize();
            }
            v = message.randomspeed ? v.scale(Math.random() * message.speed) : v.scale(message.speed);
            if (message.color == 1) {
                r = message.r;
                g = message.g;
                b = message.b;
            } else {
                r = message.r2;
                g = message.g2;
                b = message.b2;
            }
            float sz = message.big ? 1.2f : 0.2f;
            ParticleMagic p = new ParticleMagic(Minecraft.getInstance().level, message.posX, message.posY, message.posZ, 0.5f, v.x, v.y, v.z, "textures/particle/white_magic_particle", sz, r, g, b, 1.0f, true);
            Minecraft.getInstance().particleEngine.add((Particle)p);
        }
    }

    public static void replicaKnockbackParticleHandler(ReplicaKnockbackParticlePacket message) {
        ParticleSphere p = new ParticleSphere(Minecraft.getInstance().level, message.posX, message.posY, message.posZ, 0.4f, 0.0, 0.0, 0.0, RenderUtils.beam.toString(), 0.32f, message.r, message.g, message.b, 0.4f, false, 1.2f);
        Minecraft.getInstance().particleEngine.add((Particle)p);
        ParticleSphere p2 = new ParticleSphere(Minecraft.getInstance().level, message.posX, message.posY, message.posZ, 0.4f, 0.0, 0.0, 0.0, RenderUtils.beam.toString(), 0.34f, 1.0f, 1.0f, 1.0f, 0.2f, false, 1.2f);
        Minecraft.getInstance().particleEngine.add((Particle)p2);
    }

    public static Vec3 rotateVecAroundVec(Vec3 v1, Vec3 v2, float angle) {
        Vec3 z = v1.cross(v2).normalize();
        return v1.scale(Math.cos(EffectUtil.toRad(angle))).add(z.scale(Math.sin(EffectUtil.toRad(angle)))).normalize();
    }

    public static void fog(FogPacket message) {
        Entity player;
        if (Minecraft.getInstance().level != null && (player = Minecraft.getInstance().level.getEntity(message.eid)) != null) {
            double FOG_RANGE = message.range;
            Vec3 v = player.position();
            double unit = message.space;
            for (double i = -FOG_RANGE; i < FOG_RANGE; i += unit) {
                for (double j = -FOG_RANGE / 4.0; j < FOG_RANGE / 2.0; j += unit) {
                    for (double k = -FOG_RANGE; k < FOG_RANGE; k += unit) {
                        if (!(i * i + j * j + k * k < FOG_RANGE * FOG_RANGE)) continue;
                        player.level().addParticle((ParticleOptions)ModParticles.FOG1.get(), v.x + i, v.y + j, v.z + k, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public static void updateInvisible(RipperInvisiblePacket message) {
        Entity e = Minecraft.getInstance().level.getEntity(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.invisible) {
                EffectUtil.buff((LivingEntity)e, ModEffects.RIPPER_INVISIBILITY, false, 90000000, false);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.RIPPER_INVISIBILITY);
            }
        }
    }

    public static void sparkExplosion(Vec3 pos, float[] colors) {
        Vec3 v = pos;
        RandomSource rand = Minecraft.getInstance().level.random;
        for (int m = 0; m < 4; ++m) {
            Vec3 q = v;
            ParticleSphereExplosion p = new ParticleSphereExplosion(Minecraft.getInstance().level, colors, q.x, q.y, q.z);
            p.maxRadius = 10.0f;
            Minecraft.getInstance().particleEngine.add((Particle)p);
        }
    }
}

