/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.mana;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.DataAttachments;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.dataattachments.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.EquivalentDisplacementMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ManaEvents {
    public static void manaPlayerHurt(LivingEntity entity, float f) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!MTConfig.BLEEDING_FROM_DAGGER_ONLY && f > 0.0f) {
            EffectUtil.buff((LivingEntity)player, ModEffects.BLEEDING, false, 100);
        }
    }

    public static void rightClickCircle(Player player, BlockPos pos) {
        MahoujinTileEntity mte;
        BlockEntity te;
        if (!player.level().isClientSide && pos != null && (te = player.level().getBlockEntity(pos)) instanceof MahoujinTileEntity && ((mte = (MahoujinTileEntity)te).isFay() || mte.getCasterUUID() == null || mte.getCasterUUID().equals(UUID.fromString("00000000-0000-0000-0000-000000000000")))) {
            EquivalentDisplacementMahoujinTileEntity tte;
            mte.setCasterUUID(player.getUUID());
            if (mte instanceof EquivalentDisplacementMahoujinTileEntity && ((EquivalentDisplacementMahoujinTileEntity)mte).getTargetDimension() != null && ((EquivalentDisplacementMahoujinTileEntity)mte).getTargetLocation() != null && (tte = ((EquivalentDisplacementMahoujinTileEntity)mte).getTargetTE(((EquivalentDisplacementMahoujinTileEntity)mte).getTargetLocation(), ((EquivalentDisplacementMahoujinTileEntity)mte).getTargetDimension())) != null) {
                tte.setCasterUUID(player.getUUID());
            }
        }
    }

    public static void drinkMilk(LivingEntityUseItemEvent.Finish event) {
        LivingEntity e = event.getEntity();
        if (EffectUtil.inItemBlacklist(event.getItem().getItem(), MTConfig.BUFF_CLEAR_ITEMS, event.getEntity().level()) && !e.level().isClientSide) {
            Object mahou;
            if (e instanceof Player && (mahou = Utils.getPlayerMahou((Player)e)) != null) {
                mahou.clearBuffs();
                if (e instanceof ServerPlayer) {
                    PlayerManaManager.updateClientMahou((ServerPlayer)e, (IMahou)mahou);
                }
            }
            if ((mahou = Utils.getLivingMahou(e)) != null) {
                mahou.clearBuffs();
            }
        }
    }

    public static void mahouClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath() || event.getOriginal().hasData(DataAttachments.PLAYER_ATTACHMENTS)) {
            // empty if block
        }
        Player oldPlayer = event.getOriginal();
        IMahou mahou = Utils.getPlayerMahou(event.getEntity());
        mahou.copyMahou(Utils.getPlayerMahou(oldPlayer));
        PlayerManaManager.updateClientMahou((ServerPlayer)event.getEntity(), mahou);
        ISettingsMahou settingsMahou = Utils.getSettingsMahou((LivingEntity)event.getEntity());
        settingsMahou.copyMahou(Utils.getSettingsMahou((LivingEntity)oldPlayer));
    }

    public static void mahouLogin(Player player) {
        if (!player.level().isClientSide) {
            PlayerManaManager.updateClientMahou((ServerPlayer)player, Utils.getPlayerMahou(player));
        }
    }

    public static void mahouSleep(Player player) {
        long time;
        if (!(player.level().isClientSide || (time = player.level().getDayTime() % 24000L) <= 23998L && time >= 12500L || player.level().isThundering())) {
            PlayerManaManager.regenMana(player, true);
        }
    }
}

