/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic.MysticStaff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.dataattachments.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffAOEMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MysticStaff
extends ItemBase {
    private String MODE_TAG = "MAHOUTSUKAI_AOE_MODE_ON";
    private static final int beamGrowthStart = 35;
    private static final float beamGrowthRate = 1.026f;
    private static final float highestRadius = 35.0f;
    public static HashMap<UUID, MysticStaffUserStorage> staffs = new HashMap();

    public MysticStaff() {
        super("mystic_staff", 1, 20);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        staffs.remove(player.getUUID());
        MysticStaffUserStorage storage = new MysticStaffUserStorage(this);
        storage.growthStopped = false;
        storage.mahoujins = null;
        storage.target = null;
        storage.aoeTargets = null;
        storage.aoeSpawnIndex = 0;
        staffs.put(player.getUUID(), storage);
        if (player.isDiscrete()) {
            if (!world.isClientSide) {
                Utils.setMode(stack, (Utils.getMode(stack) + 1) % 3);
                int mode = Utils.getMode(stack);
                MutableComponent tt = mode == 0 ? Component.translatable((String)"mahoutsukai.mysticstaff.big") : (mode == 1 ? Component.translatable((String)"mahoutsukai.mysticstaff.aoe") : Component.translatable((String)"mahoutsukai.mysticstaff.beam"));
                player.displayClientMessage((Component)tt, true);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static float getBeamSize(MysticStaffMahoujinEntity entity, float partialTicks) {
        float last = entity.getBeamSize() / 1.026f;
        return last + partialTicks * (entity.getBeamSize() - last);
    }

    public void onUseTick(Level world, LivingEntity player, ItemStack stack, int count) {
        if (player instanceof Player) {
            MysticStaffUserStorage storage = null;
            if (staffs.containsKey(player.getUUID())) {
                storage = staffs.get(player.getUUID());
            }
            if (storage == null) {
                storage = new MysticStaffUserStorage(this);
                staffs.put(player.getUUID(), storage);
            }
            if (Utils.getMode(stack) == 0) {
                player.setDeltaMovement(0.0, player.getDeltaMovement().y * 0.3, 0.0);
                int charge = this.getRemainingUseDuration(stack, player, count);
                if (storage.mahoujins == null) {
                    storage.mahoujins = new ArrayList();
                }
                if (!player.level().isClientSide) {
                    float thunderChance;
                    if (storage.target == null) {
                        storage.target = this.getTargetBlock((Player)player);
                    }
                    if (charge == 1) {
                        this.createFloorCircle(stack, (Player)player, new Vec3(player.getX(), player.getY(), player.getZ()), 3.0f, 0.5f, storage);
                        this.createFloorCircle(stack, (Player)player, storage.target.add(new Vec3(0.0, 1.0, 0.0)), 12.0f, 0.5f, storage);
                    }
                    if (charge == 5) {
                        storage.lowest = this.createCircleAtAngle(stack, (Player)player, 10.0f, 1.5f, 10.0f, 30.0f, 15.0f, storage.target, false, 0.1f, false, storage);
                    }
                    if (charge == 8) {
                        this.createCircleAtAngle(stack, (Player)player, 15.0f, 0.5f, 10.0f, 30.0f, 22.0f, storage.target, false, 0.0f, false, storage);
                    }
                    if (charge == 13) {
                        this.createCircleAtAngle(stack, (Player)player, 20.0f, 2.0f, 10.0f, 30.0f, 30.0f, storage.target, false, 0.0f, false, storage);
                    }
                    if (charge == 15) {
                        storage.highest = this.createCircleAtAngle(stack, (Player)player, 35.0f, 1.0f, 10.0f, 30.0f, 37.0f, storage.target, true, 0.1f, false, storage);
                    }
                    if (charge > 15 && storage.highest != null && MTConfig.MYSTIC_STAFF_BIG_RAIN && (double)(thunderChance = player.getRandom().nextFloat()) < 0.1) {
                        int angle = player.getRandom().nextInt(360);
                        float radius = (float)player.getRandom().nextInt(20) + 35.0f;
                        double addX = (double)(-radius) * Math.cos(MysticStaffMahoujinEntity.toRad(angle));
                        double addZ = (double)radius * Math.sin(MysticStaffMahoujinEntity.toRad(angle));
                        double addY = player.getRandom().nextInt(10) - 5;
                        LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(player.level());
                        lightning.moveTo(new Vec3(storage.highest.getX() + addX, storage.highest.getY() + addY, storage.highest.getZ() + addZ));
                        lightning.setVisualOnly(true);
                        ((ServerLevel)player.level()).addFreshEntity((Entity)lightning);
                    }
                    if (charge > 35 && storage.lowest != null && storage.highest != null) {
                        if (storage.highest.getBeamSize() < 0.6f) {
                            storage.lowest.setBeamSize(storage.lowest.getBeamSize() * 1.026f);
                            storage.highest.setBeamSize(storage.highest.getBeamSize() * 1.026f);
                        } else {
                            storage.growthStopped = true;
                        }
                    }
                    if (MTConfig.MYSTIC_STAFF_BIG_RAIN) {
                        ((ServerLevel)player.level()).rainLevel = Math.min((float)charge / 40.0f, 2.4f);
                        ((ServerLevel)player.level()).thunderLevel = Math.min((float)charge / 40.0f, 2.4f);
                    }
                }
            } else if (Utils.getMode(stack) == 1) {
                if (!player.level().isClientSide) {
                    int mana;
                    double mana_factor = MTConfig.MYSTIC_STAFF_AOE_SCALING_MANA;
                    if (Utils.getPlayerMahou((Player)player) != null) {
                        mana_factor *= (double)Utils.getPlayerMahou((Player)player).getMaxMana();
                    }
                    if (PlayerManaManager.drainMana((Player)player, mana = (int)mana_factor + MTConfig.MYSTIC_STAFF_AOE_MANA_COST, false, false) == MTConfig.MYSTIC_STAFF_AOE_MANA_COST) {
                        Vec3 playerpos;
                        Vec3 look = player.getLookAngle();
                        Vec3 playerperp = playerpos = player.position();
                        playerperp = playerperp.add(look.normalize().scale(2.0));
                        playerperp = player.getRandom().nextBoolean() ? playerperp.add(Vec3.directionFromRotation((float)0.0f, (float)(player.yRot + 90.0f)).normalize().scale(player.getRandom().nextDouble() * 3.0 - 0.3).scale(2.0)) : playerperp.add(Vec3.directionFromRotation((float)0.0f, (float)(player.yRot - 90.0f)).normalize().scale(player.getRandom().nextDouble() * 3.0 - 0.3).scale(2.0));
                        playerperp = playerperp.add(Vec3.directionFromRotation((float)(player.xRot - 90.0f), (float)player.yRot).normalize().scale(player.getRandom().nextDouble() * 3.0 - 0.2).scale(2.0));
                        if (count % MTConfig.MYSTIC_STAFF_AOE_DELAY == 0) {
                            float[] colors = this.getColor((Player)player, 1);
                            MysticStaffAOEMahoujinEntity circle = new MysticStaffAOEMahoujinEntity(player.level(), (Player)player, colors[0], colors[1], colors[2], 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                            circle.setPos(playerperp.x, playerperp.y, playerperp.z);
                            circle.xRot = player.xRot;
                            circle.yRot = player.yRot;
                            Vec3 pos = circle.position().add(player.getLookAngle());
                            Vec3 aim = circle.position().subtract(pos);
                            circle.setCircleSize(1.5f);
                            circle.shoot(-aim.x, -aim.y, -aim.z, 3.0f, 4.0f);
                            player.level().addFreshEntity((Entity)circle);
                        }
                    }
                }
            } else if (!player.level().isClientSide) {
                if (this.getRemainingUseDuration(stack, player, count) > MysticStaffBeamMahoujinEntity.dyingticks * 2 && storage.beamMahoujinEntity == null) {
                    float[] colors = this.getColor((Player)player, 2);
                    storage.beamMahoujinEntity = new MysticStaffBeamMahoujinEntity(player.level(), (Player)player, colors[0], colors[1], colors[2]);
                    storage.beamMahoujinEntity.casterPosition(true);
                    player.level().addFreshEntity((Entity)storage.beamMahoujinEntity);
                }
                player.setDeltaMovement(0.0, 0.0, 0.0);
            } else if (this.getRemainingUseDuration(stack, player, count) > MysticStaffBeamMahoujinEntity.dyingticks * 2 && player == Minecraft.getInstance().player) {
                MahouTsukaiMod.proxy.slowDown();
            }
        }
    }

    public int getRemainingUseDuration(ItemStack stack, LivingEntity e, int charge) {
        return this.getUseDuration(stack, e) - charge;
    }

    public Vec3 getTargetBlock(Player player) {
        Vec3 target;
        HitResult result = player.pick((double)MTConfig.GLOBAL_LOOK_RANGE, 1.0f, false);
        if (result instanceof BlockHitResult) {
            target = new Vec3((double)((BlockHitResult)result).getBlockPos().getX() + 0.5, (double)((BlockHitResult)result).getBlockPos().getY(), (double)((BlockHitResult)result).getBlockPos().getZ() + 0.5);
        } else {
            Vec3 v = player.getViewVector(0.0f);
            Vec3 v2 = new Vec3(v.x * (double)MTConfig.GLOBAL_LOOK_RANGE, v.y * (double)MTConfig.GLOBAL_LOOK_RANGE, v.z * (double)MTConfig.GLOBAL_LOOK_RANGE);
            Vec3 v3 = player.getEyePosition(1.0f).add(v2);
            while (Utils.isBlockAir(player.level(), Utils.toBlockPos(v3)) && v3.y > 0.0) {
                v3 = v3.add(new Vec3(0.0, -1.0, 0.0));
            }
            target = v3;
        }
        return target;
    }

    public void createFloorCircle(ItemStack stack, Player player, Vec3 pos, float size, float speed, MysticStaffUserStorage storage) {
        float[] colors = this.getColor(player, 0);
        MysticStaffMahoujinEntity floorMahoujin = new MysticStaffMahoujinEntity(player.level(), player, false, colors[0], colors[1], colors[2], 0.95f);
        floorMahoujin.setPos(pos.x, pos.y + 0.001, pos.z);
        floorMahoujin.sizer(size);
        floorMahoujin.setRotationSpeed(speed);
        floorMahoujin.setRotationYaw(0.0f);
        floorMahoujin.setRotationPitch(0.0f);
        storage.mahoujins.add(floorMahoujin);
        player.level().addFreshEntity((Entity)floorMahoujin);
    }

    public MysticStaffMahoujinEntity createCircleAtAngle(ItemStack stack, Player player, float size, float speed, float circle, float ground, float distance, Vec3 pos, boolean beam, float beamSize, boolean aoe, MysticStaffUserStorage storage) {
        MysticStaffMahoujinEntity m;
        float[] colors = this.getColor(player, aoe ? 1 : 0);
        if (aoe) {
            m = new MysticStaffMahoujinEntity(player.level(), player, beam, colors[0], colors[1], colors[2], 0.95f);
            m.setBeamLength(0.0f);
            m.setBeamOffset(0.0f);
        } else {
            m = new MysticStaffMahoujinEntity(player.level(), player, beam, colors[0], colors[1], colors[2], 0.95f);
            m.setBeamLength(240.0f);
            m.setBeamOffset(-distance);
        }
        m.setDistance(distance);
        m.sizer(size);
        m.setRotationSpeed(speed);
        m.angleCircleAroundBlock(circle, ground, distance, pos);
        storage.mahoujins.add(m);
        player.level().addFreshEntity((Entity)m);
        if (beam) {
            m.setBeamSize(beamSize);
        }
        return m;
    }

    public Vec3 getBlockPerpToLook(Vec3 target, float playerYaw, float distance) {
        float yaw = playerYaw;
        double plusZ = (double)distance * Math.sin(MysticStaffMahoujinEntity.toRad(yaw += 90.0f));
        double plusX = (double)(-distance) * Math.cos(MysticStaffMahoujinEntity.toRad(yaw));
        return new Vec3(plusX, 0.0, plusZ).add(target);
    }

    public Vec3 getMiddleCircle(Vec3 target, Vec3 target2, float playerYaw, float distance) {
        double xhalf = (target2.x - target.x) / 2.0;
        double zhalf = (target2.z - target.z) / 2.0;
        double plusZ = (double)distance * Math.sin(MysticStaffMahoujinEntity.toRad(playerYaw));
        double plusX = (double)(-distance) * Math.cos(MysticStaffMahoujinEntity.toRad(playerYaw));
        return new Vec3(plusX += xhalf + target.x, target.y, plusZ += zhalf + target.z);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void releaseUsing(@Nonnull ItemStack stack, @Nonnull Level world, LivingEntity caster, int useTicks) {
        MysticStaffUserStorage storage;
        Player player = (Player)caster;
        if (staffs.containsKey(player.getUUID())) {
            storage = staffs.get(player.getUUID());
        } else {
            storage = new MysticStaffUserStorage(this);
            staffs.put(player.getUUID(), storage);
        }
        if (storage.mahoujins != null && !world.isClientSide) {
            int radius = MTConfig.MYSTIC_STAFF_BIG_SIZE;
            if (storage.growthStopped) {
                if (Utils.getMode(stack) == 0) {
                    int mana;
                    double mana_factor = MTConfig.MYSTIC_STAFF_SCALING_MANA;
                    if (Utils.getPlayerMahou(player) != null) {
                        mana_factor *= (double)Utils.getPlayerMahou(player).getMaxMana();
                    }
                    if (PlayerManaManager.drainMana(player, MTConfig.MYSTIC_STAFF_BIG_MANA_COST + (mana = (int)mana_factor), false, false) == MTConfig.MYSTIC_STAFF_BIG_MANA_COST + mana) {
                        double x = storage.target.x;
                        double y = storage.target.y;
                        double z = storage.target.z;
                        Bakuretsu explosion = new Bakuretsu(radius, (float)x, (float)y + (float)(radius / 2 + 2), (float)z, MysticStaff.getExplosionDamage(false, Utils.getPlayerMahou(player)));
                        explosion.explosionA(world, player);
                        ((MahouTrigger)((Object)ModTriggers.BAKURETSU.get())).trigger((ServerPlayer)player);
                        for (Player Player2 : world.players()) {
                            if (!(Player2.distanceToSqr(x, y, z) < 16384.0)) continue;
                            Vec3 vec = null;
                            if (explosion.knockback.containsKey(player)) {
                                vec = explosion.knockback.get(player);
                            }
                            if (vec == null) {
                                PacketHandler.sendTo((ServerPlayer)Player2, new BakuretsuPacket(x, y + (double)(radius / 2 + 2), z, radius, 0.0f, 0.0f, 0.0f));
                                continue;
                            }
                            PacketHandler.sendTo((ServerPlayer)Player2, new BakuretsuPacket(x, y + (double)(radius / 2 + 2), z, radius, (float)vec.x, (float)vec.y, (float)vec.z));
                        }
                        for (MysticStaffMahoujinEntity e : storage.mahoujins) {
                            e.discard();
                        }
                    }
                } else if (Utils.getMode(stack) == 1) {
                    // empty if block
                }
            }
            storage.mahoujins = new ArrayList();
        }
        if (!world.isClientSide) {
            if (storage.beamMahoujinEntity != null) {
                storage.beamMahoujinEntity.setDying(1);
                storage.beamMahoujinEntity = null;
            }
        } else {
            MahouTsukaiMod.proxy.speedUp();
        }
    }

    public static float getExplosionDamage(boolean aoe, IMahou mahou) {
        boolean scales;
        float factor;
        if (aoe) {
            factor = (float)MTConfig.MYSTIC_STAFF_AOE_FACTOR;
            scales = MTConfig.MYSTIC_STAFF_AOE_SCALES;
        } else {
            factor = (float)MTConfig.MYSTIC_STAFF_BIG_FACTOR;
            scales = MTConfig.MYSTIC_STAFF_BIG_SCALES;
        }
        if (scales && mahou != null) {
            return (float)mahou.getMaxMana() * factor;
        }
        return factor;
    }

    public float[] getColor(Player caster, int mode) {
        float[] ret = new float[]{0.0f, 0.0f, 0.0f};
        MahouSettings.Spell spell = MahouSettings.Spell.MYSTIC_STAFF_BIG;
        if (mode == 1) {
            spell = MahouSettings.Spell.MYSTIC_STAFF_AOE;
        }
        if (mode == 2) {
            spell = MahouSettings.Spell.MYSTIC_STAFF_BEAM;
        }
        List<Integer> settings = MahouSettings.getIntSettings(caster, spell);
        ret[0] = (float)settings.get(0).intValue() / 255.0f;
        ret[1] = (float)settings.get(1).intValue() / 255.0f;
        ret[2] = (float)settings.get(2).intValue() / 255.0f;
        return ret;
    }

    public static List<BlockPos> getAffectedBlocks(Level world, BlockPos target, int size) {
        ArrayList<BlockPos> lst = new ArrayList<BlockPos>();
        int r = size / 2;
        Stream box = BlockPos.betweenClosedStream((BlockPos)target.offset(-r, -r, -r), (BlockPos)target.offset(r, r, r));
        box.forEach(tmp -> {
            if (MysticStaff.getDistance(EffectUtil.fromBlockPos(tmp), EffectUtil.fromBlockPos(target)) < r) {
                lst.add(new BlockPos(tmp.getX(), tmp.getY(), tmp.getZ()));
            }
        });
        return lst;
    }

    public static int getDistance(Vec3 pos1, Vec3 pos2) {
        double x = pos1.x - pos2.x;
        double y = pos1.y - pos2.y;
        double z = pos1.z - pos2.z;
        return (int)Math.abs(Math.ceil(Math.sqrt(x * x + y * y + z * z)));
    }

    public class MysticStaffUserStorage {
        public ArrayList<MysticStaffMahoujinEntity> mahoujins;
        public boolean growthStopped = false;
        public Vec3 target = null;
        public List<Vec3> aoeTargets = null;
        public MysticStaffMahoujinEntity highest = null;
        public MysticStaffMahoujinEntity lowest = null;
        public float playerLook = 0.0f;
        public float playerPitch = 0.0f;
        public int aoeSpawnIndex = 0;
        public MysticStaffBeamMahoujinEntity beamMahoujinEntity = null;

        public MysticStaffUserStorage(MysticStaff this$0) {
        }
    }
}

