/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.datacomponents.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.util.Utils;

public class SpellScroll
extends ItemBase {
    public SpellScroll(String name) {
        super(new Item.Properties().component(DataComponents.SCROLL_COMPONENT, (Object)new ScrollMahou()));
    }

    public SpellScroll(Item.Properties prop) {
        super(prop.component(DataComponents.SCROLL_COMPONENT, (Object)new ScrollMahou()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        ScrollMahou scrollMahou;
        super.appendHoverText(stack, pContext, tooltip, pTooltipFlag);
        Item item = stack.getItem();
        if (item instanceof SpellScroll && Utils.getScrollMahou(stack) != null && (scrollMahou = Utils.getScrollMahou(stack)) != null) {
            Optional<String> name = scrollMahou.getCasterName();
            if (name.isPresent()) {
                tooltip.add((Component)Component.literal((String)("Bound to " + name.get())));
            } else {
                tooltip.add((Component)Component.literal((String)"Bound to: ???"));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        playerIn.startUsingItem(handIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        this.useAction(stack, worldIn, entityLiving, true);
    }

    public void useAction(ItemStack stack, Level worldIn, LivingEntity entityLiving, boolean consume) {
        if (!worldIn.isClientSide) {
            int cost = this.getInitialManaCost();
            ScrollMahou scrollMahou = Utils.getScrollMahou(stack);
            if (entityLiving instanceof Player) {
                Player user = (Player)entityLiving;
                if (scrollMahou != null && (scrollMahou.getCasterUUID().isEmpty() || user.getUUID().equals(scrollMahou.getCasterUUID().get()) || scrollMahou.getCasterUUID().get().equals(FaeEssence.faeID) || user.isCreative()) && PlayerManaManager.drainMana(user, cost, false, false) == cost && this.shouldConsume(user, scrollMahou, consume, stack)) {
                    stack.shrink(1);
                }
            }
        }
    }

    public boolean shouldConsume(Player user, ScrollMahou scrollMahou, boolean consume, ItemStack stack) {
        return this.doSpell(user, scrollMahou, stack) && (!user.isCreative() || MTConfig.CREATIVE_MODE_SPELLS) && consume;
    }

    public int getInitialManaCost() {
        return 0;
    }

    public boolean doSpell(Player user, ScrollMahou mahou, ItemStack stack) {
        return false;
    }

    public static boolean matchCaster(Player user, ScrollMahou mahou) {
        if (mahou == null) {
            return true;
        }
        if (user == null || user.isCreative()) {
            return true;
        }
        if (mahou.getCasterUUID().isEmpty()) {
            return true;
        }
        if (mahou.getCasterUUID().get().equals(new UUID(0L, 0L))) {
            return true;
        }
        if (mahou.getCasterUUID().get().equals(FaeEssence.faeID)) {
            return true;
        }
        return user.getUUID().equals(mahou.getCasterUUID().get());
    }
}

