/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.block.BlockBase;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.block.spells.SingleUseMahoujinBlockTileEntity;
import stepsword.mahoutsukai.integration.emi.CaliburnEmiRecipe;
import stepsword.mahoutsukai.integration.emi.ClarentEmiRecipe;
import stepsword.mahoutsukai.integration.emi.EmrysEmiRecipe;
import stepsword.mahoutsukai.integration.emi.MahouCircleEmiRecipe;
import stepsword.mahoutsukai.integration.emi.MahouScrollEmiRecipe;
import stepsword.mahoutsukai.integration.emi.MahouWeaponEmiRecipe;
import stepsword.mahoutsukai.integration.emi.MahoujinEmiStack;
import stepsword.mahoutsukai.integration.emi.MorganEmiRecipe;
import stepsword.mahoutsukai.integration.emi.ReplicaEmiRecipe;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ScrollGiver;
import stepsword.mahoutsukai.util.UnorderedList;
import stepsword.mahoutsukai.util.Utils;

@EmiEntrypoint
public class MahouEmiPlugin
implements EmiPlugin {
    public static final EmiStack MAHOUJIN = EmiStack.of((ItemLike)((ItemLike)ModBlocks.mahoujin.get()));
    public static final EmiStack SCROLLS = EmiStack.of((ItemLike)((ItemLike)ModItems.boundaryAlarmScroll.get()));
    public static final EmiRecipeCategory MAHOUJIN_RECIPES = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"mahoujin"), (EmiRenderable)MAHOUJIN);
    public static final EmiRecipeCategory SCROLL_RECIPES = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"scrolls"), (EmiRenderable)MAHOUJIN);
    public static final EmiRecipeCategory WEAPON_RECIPES = new EmiRecipeCategory(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"weapons"), (EmiRenderable)MAHOUJIN);

    public void register(EmiRegistry registry) {
        BlockBase b;
        registry.addCategory(MAHOUJIN_RECIPES);
        registry.addCategory(SCROLL_RECIPES);
        registry.addCategory(WEAPON_RECIPES);
        registry.addWorkstation(SCROLL_RECIPES, (EmiIngredient)MAHOUJIN);
        registry.addWorkstation(MAHOUJIN_RECIPES, (EmiIngredient)MAHOUJIN);
        registry.addWorkstation(WEAPON_RECIPES, (EmiIngredient)SCROLLS);
        EmiStack prev = EmiStack.of((ItemLike)((ItemLike)ModItems.dagger.get()));
        for (UnorderedList r : MahoujinRecipeRegistrar.recipes.keySet()) {
            if (MahoujinRecipeRegistrar.needsCloth.containsKey(r) && MahoujinRecipeRegistrar.needsCloth.get(r).booleanValue()) continue;
            b = MahoujinRecipeRegistrar.recipes.get(r);
            prev = this.registerMahoujin(prev, registry, r, b);
        }
        prev = EmiStack.of((ItemLike)((ItemLike)ModItems.murkyBucket.get()));
        for (UnorderedList r : MahoujinRecipeRegistrar.recipes.keySet()) {
            if (!MahoujinRecipeRegistrar.needsCloth.containsKey(r)) continue;
            b = MahoujinRecipeRegistrar.recipes.get(r);
            prev = this.registerScroll(prev, registry, r, b);
        }
        MahouEmiPlugin.registerWeaponFromScroll(registry, ModItems.presenceConcealmentScroll, ModItems.theripper);
        MahouEmiPlugin.registerWeaponFromScroll(registry, ModItems.treasuryProjectionScroll, ModItems.treasuryProjectionGauntlet);
        MahouEmiPlugin.registerWeaponFromScroll(registry, ModItems.spatialDisorientationScroll, ModItems.spatialStaff);
        MahouEmiPlugin.registerWeaponFromScroll(registry, ModItems.explosionStaffScroll, ModItems.explosionStaff);
        MahouEmiPlugin.registerWeaponFromScroll(registry, ModItems.proximityProjectionScroll, ModItems.proximityProjectionKeys);
        MahouEmiPlugin.registerWeaponFromScroll(registry, ModItems.probabilityAlterScroll, ModItems.ruleBreaker);
        MahouEmiPlugin.registerWeaponFromScroll(registry, ModItems.weaponShooterScroll, ModItems.weaponShooterBow);
        registry.addRecipe((EmiRecipe)new CaliburnEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"caliburn")));
        registry.addRecipe((EmiRecipe)new MorganEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"morgan")));
        registry.addRecipe((EmiRecipe)new ReplicaEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"replica")));
        registry.addRecipe((EmiRecipe)new ClarentEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"clarent")));
        registry.addRecipe((EmiRecipe)new EmrysEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"emrys")));
    }

    public static void registerWeaponFromScroll(EmiRegistry registry, Holder<Item> scroll, Holder<Item> weapon) {
        String item_id = Utils.getRegistryKey((Item)weapon.value(), (Level)Minecraft.getInstance().level).getPath();
        registry.addRecipe((EmiRecipe)new MahouWeaponEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)item_id), weapon, scroll));
    }

    public EmiStack registerMahoujin(EmiStack prev, EmiRegistry registry, UnorderedList recipe, BlockBase b) {
        String block_id = Utils.getRegistryKey(b, (Level)Minecraft.getInstance().level).getPath();
        MahoujinEmiStack block = new MahoujinEmiStack(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)("mahoujin_" + block_id + "_emi")), b, recipe);
        registry.addEmiStackAfter((EmiStack)block, prev);
        registry.addRecipe((EmiRecipe)new MahouCircleEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)("/mahoujin/" + block_id)), recipe, block));
        return block;
    }

    public EmiStack registerScroll(EmiStack prev, EmiRegistry registry, UnorderedList recipe, BlockBase b) {
        String block_id = Utils.getRegistryKey(b, (Level)Minecraft.getInstance().level).getPath();
        MahoujinEmiStack block = new MahoujinEmiStack(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)("mahoujin_" + block_id + "_emi")), b, recipe, true);
        MahoujinTileEntity mte = (MahoujinTileEntity)((Object)((SingleUseMahoujinBlockTileEntity)b).createTileEntity(new BlockPos(0, 0, 0), b.defaultBlockState(), null));
        if (mte instanceof ScrollGiver) {
            ScrollGiver sg = (ScrollGiver)((Object)mte);
            EmiStack scroll = EmiStack.of((ItemStack)sg.getItemToGive());
            String scroll_id = Utils.getRegistryKey(sg.getItemToGive().getItem(), (Level)Minecraft.getInstance().level).getPath();
            registry.addRecipe((EmiRecipe)new MahouScrollEmiRecipe(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)scroll_id), recipe, block, scroll));
            return scroll;
        }
        return EmiStack.EMPTY;
    }
}

