/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.integration.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.integration.emi.EntityEmiStack;
import stepsword.mahoutsukai.integration.emi.MahouEmiPlugin;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.util.Utils;

public class ClarentEmiRecipe
extends BasicEmiRecipe {
    public ClarentEmiRecipe(ResourceLocation id) {
        super(MahouEmiPlugin.SCROLL_RECIPES, id, 134, 120);
        this.inputs.add(EmiStack.of((ItemLike)((ItemLike)ModItems.strengtheningScroll.get())));
        ArrayList<EmiStack> swords = new ArrayList<EmiStack>();
        for (Holder<Item> holder : Utils.getItemsFromTag((TagKey<Item>)ItemTags.SWORDS)) {
            if (ClarentEffect.blacklisted(new ItemStack(holder), (Level)Minecraft.getInstance().level)) continue;
            swords.add(EmiStack.of((ItemLike)((ItemLike)holder.value())));
        }
        this.inputs.add(EmiIngredient.of(swords));
        AreaEffectCloud cloud = new AreaEffectCloud((Level)Minecraft.getInstance().level, 0.0, 0.0, 0.0);
        cloud.setParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH);
        cloud.setRadius(3.0f);
        cloud.setDuration(600);
        cloud.setRadiusPerTick((7.0f - cloud.getRadius()) / (float)cloud.getDuration());
        cloud.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
        this.inputs.add(new EntityEmiStack(ResourceLocation.withDefaultNamespace((String)"area_effect_cloud"), (Entity)cloud));
        this.outputs.add(EmiStack.of((ItemLike)((ItemLike)ModItems.clarent.get())));
    }

    public void addWidgets(WidgetHolder widgets) {
        int px = 26;
        int offset = 0;
        int right = 0;
        widgets.addSlot((EmiIngredient)this.inputs.get(0), offset + right * px, 0);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, offset + ++right * px, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), (offset += 6) + ++right * px, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(2), offset + right * px, 26);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, offset + ++right * px, 13);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), (offset += 6) + ++right * px, 13).recipeContext((EmiRecipe)this);
        TextWidget t = widgets.addText((Component)Component.translatable((String)"Right click with a strengthened sword while standing in dragon's breath"), 4, 58, 0, false);
        Bounds b = t.getBounds();
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree();
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }

    @Nullable
    public RecipeHolder<?> getBackingRecipe() {
        return super.getBackingRecipe();
    }
}

