/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class BeamProjectileEntity
extends Entity {
    public static final String entityName = "beam_projectile_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_COLOR_A2 = "MAHOUTSUKAI_COLOR_A2";
    private static final String TAG_RADIUS = "MAHOUTSUKAI_RADIUS";
    private static final String TAG_LENGTH = "MAHOUTSUKAI_LENGTH";
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A2 = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.defineId(BeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public ArrayList<EffectInstance> effects = new ArrayList();
    public float damage = 0.0f;
    public int ticksSinceFired = 0;
    public long timeCreated = -1L;

    public BeamProjectileEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public BeamProjectileEntity(Level world) {
        super((EntityType)ModEntities.BEAM_PROJECTILE.get(), world);
        this.noCulling = true;
    }

    public BeamProjectileEntity(Level world, UUID caster, float r, float g, float b, float a, float r2, float g2, float b2, float a2, float radius, float length) {
        this(world);
        this.setCasterUUID(caster);
        this.setColor(r, g, b, a, r2, g2, b2, a2);
        this.setRadius(radius);
        this.setLength(length);
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_R2, (Object)Float.valueOf(r2));
        this.entityData.set(COLOR_G2, (Object)Float.valueOf(g2));
        this.entityData.set(COLOR_B2, (Object)Float.valueOf(b2));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
        this.entityData.set(COLOR_A2, (Object)Float.valueOf(a2));
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue(), ((Float)this.entityData.get(COLOR_R2)).floatValue(), ((Float)this.entityData.get(COLOR_G2)).floatValue(), ((Float)this.entityData.get(COLOR_B2)).floatValue(), ((Float)this.entityData.get(COLOR_A2)).floatValue()};
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(CASTER_UUID, Optional.empty());
        builder.define(FIRED, (Object)false);
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A2, (Object)Float.valueOf(1.0f));
        builder.define(RADIUS, (Object)Float.valueOf(1.0f));
        builder.define(LENGTH, (Object)Float.valueOf(1.0f));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setLife(compound.getInt(TAG_LIFE));
        this.setFired(compound.getBoolean(TAG_FIRED));
        if (compound.hasUUID(TAG_CASTER)) {
            this.setCasterUUID(compound.getUUID(TAG_CASTER));
        }
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A), compound.getFloat(TAG_COLOR_R2), compound.getFloat(TAG_COLOR_G2), compound.getFloat(TAG_COLOR_B2), compound.getFloat(TAG_COLOR_A2));
        this.setLength(compound.getFloat(TAG_LENGTH));
        this.setRadius(compound.getFloat(TAG_RADIUS));
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putBoolean(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.putUUID(TAG_CASTER, this.getCasterUUID());
        }
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putFloat(TAG_COLOR_R2, colors[4]);
        compound.putFloat(TAG_COLOR_G2, colors[5]);
        compound.putFloat(TAG_COLOR_B2, colors[6]);
        compound.putFloat(TAG_COLOR_A2, colors[7]);
        compound.putFloat(TAG_LENGTH, this.getLength());
        compound.putFloat(TAG_RADIUS, this.getRadius());
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
    }

    public void tick() {
        super.tick();
        if (this.timeCreated == -1L) {
            this.timeCreated = this.level().getGameTime();
        }
        this.setLife(this.getLife() + 1);
        if (!(this.level().isClientSide || this.ticksSinceFired <= 400 && this.level().getGameTime() - this.timeCreated <= 800L)) {
            this.discard();
        }
        ++this.ticksSinceFired;
        if (!this.level().isClientSide) {
            this.setLength((float)Math.min(3.0, (double)this.getLength() + this.getDeltaMovement().length() / 5.0));
            this.checkHit();
        }
        this.teleportTo(this.getX() + this.getDeltaMovement().x, this.getY() + this.getDeltaMovement().y, this.getZ() + this.getDeltaMovement().z);
    }

    public void checkHit() {
        EntityHitResult entityraytraceresult;
        Vec3 vec3d = this.getDeltaMovement();
        Vec3 vec3d2 = this.position();
        Vec3 vec3d3 = vec3d2.add(vec3d);
        BlockHitResult raytraceresult = this.level().clip(new ClipContext(vec3d2, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.getType() != HitResult.Type.MISS) {
            vec3d3 = raytraceresult.getLocation();
        }
        if ((entityraytraceresult = this.rayTraceEntities(vec3d2, vec3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult.getType() == HitResult.Type.ENTITY && raytraceresult instanceof EntityHitResult) {
            Entity entity = ((EntityHitResult)raytraceresult).getEntity();
            Entity entity1 = this.getShooter();
            if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity) && !ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getCasterUUID(), entity)) {
                raytraceresult = null;
                entityraytraceresult = null;
            }
        }
        if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS) {
            this.onHit((HitResult)raytraceresult);
        }
        raytraceresult = null;
    }

    public void onHit(HitResult result) {
        Vec3 target = result.getLocation();
        double x = target.x;
        double y = target.y;
        double z = target.z;
        Player caster = this.level().getPlayerByUUID(this.getCasterUUID());
        if (caster != null) {
            int radius = MTConfig.MYSTIC_STAFF_AOE_SIZE;
            Bakuretsu explosion = new Bakuretsu(radius, (float)x, (float)y, (float)z, MysticStaff.getExplosionDamage(true, Utils.getPlayerMahou(caster)));
            explosion.explosionA(this.level(), caster);
            for (Player entityplayer : this.level().players()) {
                if (!(entityplayer.distanceToSqr(x, y, z) < 16384.0)) continue;
                Vec3 vec = null;
                if (explosion.knockback.containsKey(caster)) {
                    vec = explosion.knockback.get(caster);
                }
                if (vec == null) {
                    PacketHandler.sendTo((ServerPlayer)caster, new BakuretsuPacket(x, y, z, radius, 0.0f, 0.0f, 0.0f));
                    continue;
                }
                PacketHandler.sendTo((ServerPlayer)caster, new BakuretsuPacket(x, y, z, radius, (float)vec.x, (float)vec.y, (float)vec.z));
            }
        }
        this.discard();
    }

    public Vec3 setLookPos(boolean client, Entity caster, boolean add) {
        Vec3 look = caster.getLookAngle();
        Vec3 oldlook = look.normalize();
        look = oldlook.scale((double)1.1f);
        Vec3 start = look.add(caster.position());
        this.yRot = caster.yRot;
        this.xRot = caster.xRot;
        if (add) {
            this.xRot = 90.0f - this.xRot;
        }
        this.yRotO = this.yRot;
        this.xRotO = this.xRot;
        if (!client && add) {
            this.setPos(start.x, start.y, start.z);
        }
        return start;
    }

    @Nullable
    public Entity getShooter() {
        return this.getCasterUUID() != null && this.level() instanceof ServerLevel ? ((ServerLevel)this.level()).getEntity(this.getCasterUUID()) : null;
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), p_213871_1_ -> !p_213871_1_.isSpectator() && p_213871_1_.isAlive() && p_213871_1_.isPickable() && !(p_213871_1_ instanceof BeamProjectileEntity) && (!p_213871_1_.getUUID().equals(this.getCasterUUID()) || this.ticksSinceFired >= 5));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.entityData.get(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.entityData.set(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.entityData.get(FIRED);
    }

    public void setFired(boolean f) {
        this.entityData.set(FIRED, (Object)f);
    }

    public float getLength() {
        return ((Float)this.entityData.get(LENGTH)).floatValue();
    }

    public void setLength(float f) {
        this.entityData.set(LENGTH, (Object)Float.valueOf(f));
    }

    public float getRadius() {
        return ((Float)this.entityData.get(RADIUS)).floatValue();
    }

    public void setRadius(float f) {
        this.entityData.set(RADIUS, (Object)Float.valueOf(f));
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }
}

