/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class GateChainEntity
extends Entity {
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_LENGTH = "MAHOUTSUKAI_LENGTH";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static float speed = 4.2f;
    public boolean dying = false;
    public int dyingticks = 0;
    public float lastlen = 0.0f;
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.defineId(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.defineId(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final String entityName = "gate_chain_mahoujin_entity";
    public Vec3 target = null;

    public GateChainEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public GateChainEntity(Level world) {
        super((EntityType)ModEntities.GATE_CHAIN.get(), world);
        this.noCulling = true;
    }

    public GateChainEntity(Level world, float r, float g, float b, float a, Vec3 pos, Vec3 target) {
        this(world);
        this.setColor(r, g, b, a);
        this.target = target;
        this.setPos(pos.x, pos.y, pos.z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(LENGTH, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setCircleSize(compound.getFloat(TAG_CIRCLE_SIZE));
        this.setLife(compound.getInt(TAG_LIFE));
        this.setLength(compound.getInt(TAG_LENGTH));
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putFloat(TAG_LENGTH, this.getLength());
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public float getLength() {
        return ((Float)this.entityData.get(LENGTH)).floatValue();
    }

    public void setLength(float l) {
        this.entityData.set(LENGTH, (Object)Float.valueOf(l));
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue()};
    }

    public void setColor(float r, float g, float b, float a) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (!this.dying) {
                if (ServerHandler.tickCounter % (long)MTConfig.TREASURY_PROJECTION_CHAINS_COOLDOWN == 0L) {
                    this.setLife(this.getLife() + 1);
                    if (this.getLife() > 20) {
                        this.startDying();
                    }
                }
                if (this.target != null) {
                    Vec3 tv = this.target;
                    if ((double)this.getLength() < tv.distanceTo(this.position())) {
                        this.setLength(this.getLength() + speed);
                    } else if (Utils.isBlockAir(this.level(), Utils.toBlockPos(this.target))) {
                        this.startDying();
                    }
                    this.collideWithNearbyEntities();
                }
            } else {
                this.die();
            }
        }
        this.lastlen = this.getLength();
    }

    protected void collideWithNearbyEntities() {
        float len = this.getLength();
        AABB aabb = new AABB(this.getX() - (double)len, this.getY() - (double)len, this.getZ() - (double)len, this.getX() + (double)len, this.getY() + (double)len, this.getZ() + (double)len);
        List list = this.level().getEntities((Entity)this, aabb, EntitySelector.pushableBy((Entity)this));
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (!(entity instanceof LivingEntity) || !this.boxIntersectsLine(entity.getBoundingBox())) continue;
                this.push(entity);
            }
        }
    }

    public boolean boxIntersectsLine(AABB aabb) {
        return Utils.CheckLineBox(new Vec3(aabb.minX, aabb.minY, aabb.minZ), new Vec3(aabb.maxX, aabb.maxY, aabb.maxZ), this.position(), this.position().add(this.target.subtract(this.position()).normalize().scale((double)this.getLength())));
    }

    public void push(Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            EffectUtil.magicAttack((LivingEntity)entityIn, (float)MTConfig.TREASURY_PROJECTION_CHAINS_DAMAGE, null);
            Vec3 v = this.position().subtract(entityIn.position());
            this.boop(entityIn, 0.3f, v.x, 0.0, v.z);
        }
    }

    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public void startDying() {
        this.dying = true;
    }

    public void die() {
        ++this.dyingticks;
        if (this.getLength() <= 0.5f) {
            this.discard();
        } else {
            this.setLength(this.getLength() - speed / 2.0f);
        }
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.hasImpulse = true;
        float f = Mth.sqrt((float)((float)(x * x + z * z + y * y)));
        Vec3 motion = this.getDeltaMovement();
        double motionX = motion.x();
        double motionY = motion.y();
        double motionZ = motion.z();
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.hurtMarked = true;
        if (entity.onGround()) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        entity.setDeltaMovement(motionX, motionY, motionZ);
    }

    public void shoot(double x, double y, double z) {
        Vec3 Vec32 = new Vec3(x, y, z).normalize();
        float f = Mth.sqrt((float)((float)Vec32.horizontalDistanceSqr()));
        this.yRot = (float)(Mth.atan2((double)Vec32.x, (double)Vec32.z) * 57.2957763671875);
        this.xRot = (float)(Mth.atan2((double)Vec32.y, (double)f) * 57.2957763671875);
        this.yRotO = this.yRot;
        this.xRotO = this.xRot;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (amount > 4.0f) {
            this.startDying();
            return true;
        }
        return false;
    }
}

