/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.secret;

import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.util.Utils;

public class GeasEffect {
    public static String BREAK = "==MAHOU==";

    public static boolean geasEffect(Player caster) {
        Entity e = Utils.selectEntityNearCursor(caster, MTConfig.GLOBAL_LOOK_RANGE, caster.level(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.SCROLL_GEAS, a, caster), Utils.nearAllowed(Utils.MAHOU_SELECTION.SCROLL_GEAS));
        if (e instanceof LivingEntity) {
            return GeasEffect.addGeas(caster, (LivingEntity)e);
        }
        if (e instanceof ItemEntity) {
            return GeasEffect.addGeas(caster, (ItemEntity)e);
        }
        MutableComponent tt = Component.translatable((String)"mahoutsukai.geas.geasa");
        tt.append((Component)Component.literal((String)(" " + GeasEffect.getGeasString(caster))));
        if (caster instanceof ServerPlayer) {
            caster.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.AQUA) + tt.getString())), false);
        }
        return false;
    }

    public static boolean geasItem(ItemEntityPickupEvent.Pre event) {
        boolean ret = GeasEffect.hasGeas(event.getPlayer(), event.getItemEntity().getItem());
        if (ret) {
            MandatoryFun.completeFunReq(event.getPlayer(), MandatoryFun.FUN_REQS.GEAS_PICKUP_CANCEL);
        }
        return ret;
    }

    public static boolean geasLivingHurt(LivingIncomingDamageEvent event) {
        LivingEntity target = event.getEntity();
        Entity e = event.getSource().getEntity();
        if (e instanceof Player) {
            return GeasEffect.hasGeas((Player)e, target);
        }
        return false;
    }

    public static boolean geasAttackEntity(AttackEntityEvent event) {
        Entity target = event.getTarget();
        Player e = event.getEntity();
        if (target instanceof LivingEntity && GeasEffect.hasGeas(e, (LivingEntity)target)) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public static boolean addGeas(Player player, LivingEntity target) {
        String message;
        Object geas;
        boolean r = true;
        if (target instanceof Player) {
            geas = target.getDisplayName().getString() + BREAK + "minecraft:player";
            message = target.getDisplayName().getString();
        } else {
            geas = Utils.getRegistryName((Entity)target);
            message = target.getDisplayName().getString();
            if (target.getCustomName() != null && !player.isDiscrete()) {
                message = target.getCustomName().getString();
                geas = target.getCustomName().getString() + BREAK + (String)geas;
            }
        }
        r = GeasEffect.add(player, message, ChatFormatting.stripFormatting((String)geas));
        return r;
    }

    public static boolean add(Player player, String message, String geas) {
        boolean r = true;
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            String added = "mahoutsukai.geas.added";
            if (geasList.contains(geas)) {
                added = "mahoutsukai.geas.removed";
                geasList.remove(geas);
                r = false;
            } else {
                geasList.add(geas);
            }
            MutableComponent tt = Component.translatable((String)added);
            tt.append((Component)Component.literal((String)(" " + message)));
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).displayClientMessage((Component)tt, true);
            }
        }
        return r;
    }

    public static boolean addGeas(Player player, ItemEntity item) {
        boolean r = true;
        String s = "Item:" + item.getItem().getItem().getName(item.getItem()).getString();
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            r = GeasEffect.add(player, s, ChatFormatting.stripFormatting((String)s));
        }
        return r;
    }

    public static boolean hasGeas(Player player, ItemStack item) {
        String s = "Item:" + item.getItem().getName(item).getString();
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            for (String g : geasList) {
                if (!g.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGeas(Player player, LivingEntity target) {
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            String nameDisplay = "";
            if (target.getCustomName() != null) {
                nameDisplay = target.getCustomName().getString();
            }
            if (target instanceof Player) {
                nameDisplay = target.getDisplayName().getString();
            }
            String nameType = Utils.getRegistryName((Entity)target);
            for (String g : geasList) {
                String[] lst;
                if (!(g.contains(BREAK) ? (lst = g.split(BREAK)).length >= 2 && lst[0].equals(nameDisplay) && lst[1].equals(nameType) : nameType.equals(g))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getGeasString(Player player) {
        Object geasa = "";
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            for (String g : geasList) {
                String[] lst = g.split(BREAK);
                if (!((String)geasa).equals("")) {
                    geasa = (String)geasa + ", ";
                }
                if (lst.length > 1) {
                    geasa = (String)geasa + GeasEffect.regToName(lst[1]);
                    geasa = (String)geasa + " - " + lst[0];
                    continue;
                }
                geasa = (String)geasa + GeasEffect.regToName(lst[0]);
            }
        }
        return geasa;
    }

    public static int getUniqueGeasCount(Player player) {
        int geasa = 0;
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            for (String g : geasList) {
                String[] lst = g.split(BREAK);
                if (lst.length != 1 || lst[0].startsWith("Item:")) continue;
                ++geasa;
            }
        }
        return geasa;
    }

    public static String regToName(String res) {
        if (!res.startsWith("Item:")) {
            ResourceLocation loc = ResourceLocation.parse((String)res);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(loc);
            if (type != null) {
                return type.getDescription().getString();
            }
            return res;
        }
        return res;
    }
}

