/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.familiar;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.util.Utils;

public class SummonFamiliarSpellEffect {
    public static HashMap<UUID, FamiliarEntity> familiarMap = new HashMap();

    public static void summonFamiliar(Player caster) {
        if (!caster.level().isClientSide) {
            FamiliarEntity old;
            FamiliarEntity familiar = new FamiliarEntity(caster.level());
            Vec3 casterPos = new Vec3(caster.getX(), caster.getY(), caster.getZ());
            casterPos = casterPos.add(0.0, (double)caster.getEyeHeight(), 0.0);
            Vec3 familiarPos = casterPos.add(caster.getLookAngle().normalize().scale(1.0));
            familiar.setPos(familiarPos.x, familiarPos.y, familiarPos.z);
            familiar.setFamiliarId(UUID.randomUUID());
            familiar.setOwnerUUID(caster.getUUID());
            if (familiarMap.containsKey(caster.getUUID()) && (old = familiarMap.get(caster.getUUID())) != null && old.isAlive()) {
                old.discard();
            }
            familiarMap.put(caster.getUUID(), familiar);
            caster.level().addFreshEntity((Entity)familiar);
        }
    }

    public static void familiarRightClick(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof FamiliarEntity && !event.getTarget().level().isClientSide && event.getHand() == InteractionHand.MAIN_HAND) {
            FamiliarEntity fe = (FamiliarEntity)event.getTarget();
            if (event.getEntity().getMainHandItem().getItem() instanceof BlockItem) {
                fe.setSearchBlock(Utils.getRegistryName(((BlockItem)event.getEntity().getMainHandItem().getItem()).getBlock(), event.getLevel()));
            } else if (event.getEntity().getUUID().equals(((FamiliarEntity)event.getTarget()).getOwnerUUID())) {
                fe.toggleHoliday();
                fe.setSearchBlock(null);
            }
        }
    }
}

