/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.dataattachments.livingmahou;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import stepsword.mahoutsukai.dataattachments.DAUtils;
import stepsword.mahoutsukai.dataattachments.livingmahou.ILivingMahou;

public class LivingMahouStorage {
    private static String AUTHORITY_HIT = "MAHOUTSUKAI_AUTHORITY_HIT";
    private static String FEAR_PERSON = "MAHOUTSUKAI_FEAR_PERSON";
    private static String WOUNDED = "MAHOUTSUKAI_WOUNDED";
    private static String KODOKU = "MAHOUTSUKAI_KODOKU";
    private static String ACTING = "MAHOUTSUKAI_KODOKU";
    private static String ACTING_LOC = "MAHOUTSUKAI_KODOKU";

    public static Tag writeNBT(ILivingMahou instance) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(KODOKU, instance.getKodoku());
        if (instance.getFearPerson() != null) {
            nbt.putUUID(FEAR_PERSON, instance.getFearPerson());
        }
        nbt.putBoolean(AUTHORITY_HIT, instance.getAuthorityHit());
        nbt = DAUtils.v3w(WOUNDED, instance.getLastWoundedPos(), nbt);
        nbt.putInt(ACTING, instance.getActing());
        nbt = DAUtils.v3w(ACTING_LOC, instance.getActingLoc(), nbt);
        return nbt;
    }

    public static void readNBT(ILivingMahou instance, Tag nbtb) {
        CompoundTag nbt = (CompoundTag)nbtb;
        instance.clearBuffs();
        if (nbt.hasUUID(FEAR_PERSON)) {
            instance.setFearPerson(nbt.getUUID(FEAR_PERSON));
        } else {
            instance.setFearPerson(null);
        }
        instance.setAuthorityHit(nbt.getBoolean(AUTHORITY_HIT));
        instance.setLastWoundedPos(DAUtils.v3r(WOUNDED, nbt));
        instance.setKodoku(nbt.getInt(KODOKU));
        instance.setActing(nbt.getInt(ACTING));
        instance.setActingLoc(DAUtils.v3r(ACTING_LOC, nbt));
    }
}

