/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.jade;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import shetiphian.core.SideExecutor;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public final class JadePlugin
implements IWailaPlugin {
    private static final ResourceLocation CONFIG_BASIC = EnderTanks.RESOURCE.apply("hud.basic");
    private static final ResourceLocation CONFIG_CONTENTS = EnderTanks.RESOURCE.apply("hud.contents");
    private static final ResourceLocation CONFIG_STATUS = EnderTanks.RESOURCE.apply("hud.status");

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)ComponentProvider.INSTANCE, TileEntityEnderTank.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(CONFIG_BASIC, true);
        registration.addConfig(CONFIG_CONTENTS, true);
        registration.addConfig(CONFIG_STATUS, true);
        registration.registerBlockComponent((IComponentProvider)ComponentProvider.INSTANCE, BlockEnderTank.class);
    }

    private static class ComponentProvider
    implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor> {
        private static final ComponentProvider INSTANCE = new ComponentProvider();
        private static final ResourceLocation INFO_PROVIDER_ID = EnderTanks.RESOURCE.apply("hud");
        private static final ItemStack COMPARATOR = new ItemStack((ItemLike)Items.COMPARATOR);

        private ComponentProvider() {
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            CompoundTag data = accessor.getServerData();
            if (!data.contains("endertanks_basic")) {
                tooltip.add((Component)Component.translatable((String)"hud.endertanks.server_data_missing"));
                return;
            }
            RegistryAccess access = this.getRegistryAccess(accessor.getLevel());
            if (access != null) {
                ArrayList<Component> lines = new ArrayList<Component>();
                if (config.get(CONFIG_BASIC)) {
                    TankInfoHelper.unpackHUDInfo(lines, data.getList("endertanks_basic", 8), (HolderLookup.Provider)access);
                }
                if (config.get(CONFIG_CONTENTS) && data.contains("endertanks_contents")) {
                    TankInfoHelper.unpackHUDInfo(lines, data.getList("endertanks_contents", 8), (HolderLookup.Provider)access);
                }
                tooltip.addAll(lines);
                if (config.get(CONFIG_STATUS) && data.contains("endertanks_status")) {
                    lines.clear();
                    TankInfoHelper.unpackHUDInfo(lines, data.getList("endertanks_status", 8), (HolderLookup.Provider)access);
                    tooltip.add((Component)lines.get(0));
                    IElementHelper elements = IElementHelper.get();
                    IElement icon = elements.item(COMPARATOR, 0.5f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2(0.0f, -1.0f)).message(null);
                    tooltip.add(icon);
                    tooltip.append((Component)lines.get(1));
                }
            }
        }

        public void appendServerData(CompoundTag data, BlockAccessor accessor) {
            BlockEntity blockEntity;
            RegistryAccess access = this.getRegistryAccess(accessor.getLevel());
            if (access != null && (blockEntity = accessor.getBlockEntity()) instanceof TileEntityEnderTank) {
                TileEntityEnderTank tank = (TileEntityEnderTank)blockEntity;
                data.put("endertanks_basic", (Tag)TankInfoHelper.packHUDBasic(tank, (HolderLookup.Provider)access));
                if (accessor.showDetails()) {
                    data.put("endertanks_contents", (Tag)TankInfoHelper.packHUDContents(tank, (HolderLookup.Provider)access));
                    data.put("endertanks_status", (Tag)TankInfoHelper.packHUDStatus(tank, (HolderLookup.Provider)access));
                }
            }
        }

        private RegistryAccess getRegistryAccess(Level world) {
            return (RegistryAccess)SideExecutor.executeOn(() -> () -> Minecraft.getInstance().player.registryAccess(), () -> () -> {
                RegistryAccess registryAccess;
                if (world instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)world;
                    registryAccess = server.registryAccess();
                } else {
                    registryAccess = null;
                }
                return registryAccess;
            });
        }

        public ResourceLocation getUid() {
            return INFO_PROVIDER_ID;
        }
    }
}

