/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers.mekanism;

import com.google.common.base.Strings;
import mekanism.api.Action;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.MissingHandlerEvent;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.modintegration.handlers.mekanism.WrapperChemicalHandler;

public final class TypeChemical {
    private static final BlockCapability<IChemicalHandler, Direction> CHEMICAL_HANDLER = Capabilities.CHEMICAL.block();

    public static void init(RegisterCapabilitiesEvent event) {
        if (IChemicalHandler.class != null) {
            HandlerRegistry.register(EnderTanks.RESOURCE.apply("mekanism_chemical"), CHEMICAL_HANDLER.typeClass(), GasTankHandler::new);
            event.registerBlockEntity(CHEMICAL_HANDLER, (BlockEntityType)Roster.Tiles.ENDERTANK.get(), (tile, side) -> tile.getTankStorage(IChemicalHandler.class, (Direction)side));
            NeoForge.EVENT_BUS.addListener(MissingHandlerEvent.class, missingHandlerEvent -> {
                switch (missingHandlerEvent.getProviderId()) {
                    case "mekanism_gas": 
                    case "mekanism.api.chemical.gas.IGasHandler": 
                    case "mekanism_infusion": 
                    case "mekanism.api.chemical.infuse.IInfusionHandler": 
                    case "mekanism_pigment": 
                    case "mekanism.api.chemical.pigment.IPigmentHandler": 
                    case "mekanism_slurry": 
                    case "mekanism.api.chemical.slurry.ISlurryHandler": {
                        missingHandlerEvent.setProvider(EnderTanks.IDSTRING.apply("mekanism_chemical"));
                    }
                }
            });
        }
    }

    public static final class GasTankHandler
    implements ITankHandler<IChemicalHandler> {
        private final BasicChemicalTank chemTank;
        private final IChemicalHandler chemTankInsertOnly;
        private final IChemicalHandler chemTankExtractOnly;
        private long tankCapacity;

        private GasTankHandler(final IEnderTankInfo tank) {
            this.tankCapacity = (long)tank.getCapacity() * 1000L;
            this.chemTank = new BasicChemicalTank(this.tankCapacity, (stack, type) -> true, (stack, type) -> true, stack -> true, ChemicalAttributeValidator.ALWAYS_ALLOW, null){

                public long getCapacity() {
                    return tankCapacity;
                }

                public void onContentsChanged() {
                    tank.notifyContentsChange();
                }
            };
            this.chemTankInsertOnly = new WrapperChemicalHandler((IChemicalHandler)this.chemTank, true, false);
            this.chemTankExtractOnly = new WrapperChemicalHandler((IChemicalHandler)this.chemTank, false, true);
        }

        @Override
        public IChemicalHandler getTank(StorageAccessMode access) {
            return switch (access) {
                case StorageAccessMode.INSERT_ONLY -> this.chemTankInsertOnly;
                case StorageAccessMode.EXTRACT_ONLY -> this.chemTankExtractOnly;
                default -> this.chemTank;
            };
        }

        @Override
        public void setCapacity(int capacity) {
            int newCapacity = capacity * 1000;
            if (this.tankCapacity != (long)newCapacity) {
                this.tankCapacity = newCapacity;
                this.chemTank.onContentsChanged();
            }
        }

        @Override
        public CompoundTag portFromOldProvider(CompoundTag nbt, String oldProviderKey) {
            CompoundTag stored;
            String name;
            switch (oldProviderKey) {
                case "mekanism_gas": 
                case "mekanism.api.chemical.gas.IGasHandler": {
                    String string = "gasName";
                    break;
                }
                case "mekanism_infusion": 
                case "mekanism.api.chemical.infuse.IInfusionHandler": {
                    String string = "infuseTypeName";
                    break;
                }
                case "mekanism_pigment": 
                case "mekanism.api.chemical.pigment.IPigmentHandler": {
                    String string = "pigmentName";
                    break;
                }
                case "mekanism_slurry": 
                case "mekanism.api.chemical.slurry.ISlurryHandler": {
                    String string = "slurryName";
                    break;
                }
                default: {
                    String string = name = "";
                }
            }
            if (!Strings.isNullOrEmpty((String)name) && nbt.contains("stored", 10) && (stored = nbt.getCompound("stored")).contains(name, 8)) {
                stored.putString("id", stored.getString(name));
            }
            return nbt;
        }

        @Override
        public void load(CompoundTag nbt, HolderLookup.Provider provider) {
            this.chemTank.deserializeNBT(provider, nbt);
        }

        @Override
        public CompoundTag save(HolderLookup.Provider provider) {
            return !this.chemTank.isEmpty() ? this.chemTank.serializeNBT(provider) : null;
        }

        @Override
        public MutableComponent getContentsInfo() {
            ChemicalStack stack = this.chemTank.getStack();
            if (!stack.isEmpty()) {
                return Component.literal((String)" ").append((Component)Component.translatable((String)"info.endertanks.tank.type.mekanism.chemical")).append(" ").append((Component)Component.translatable((String)stack.getTranslationKey())).append(" [" + (float)stack.getAmount() / 1000.0f + "K/" + this.chemTank.getCapacity() / 1000L + "K mB]");
            }
            return null;
        }

        @Override
        public void preformPumpAction(Level world, BlockPos pos, Direction facing, BlockPos pullFromPos, BlockPos pushToPos, byte internalPump, RandomSource random) {
            IChemicalHandler toHandler;
            ChemicalStack gasStack;
            long used;
            IChemicalHandler fromHandler;
            int pumpCapacity;
            if (world.isClientSide() || internalPump == 0) {
                return;
            }
            int n = pumpCapacity = internalPump < 0 ? 250 : internalPump * 1000;
            if (this.chemTank.getStored() < this.chemTank.getCapacity() && (fromHandler = this.getHandler(world, pullFromPos, facing)) != null && (used = (gasStack = fromHandler.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - this.chemTank.insertChemical(gasStack, Action.SIMULATE).getAmount()) > 0L) {
                this.chemTank.insertChemical(fromHandler.extractChemical(used, Action.EXECUTE), Action.EXECUTE);
            }
            if (!this.chemTank.isEmpty() && (toHandler = this.getHandler(world, pushToPos, facing.getOpposite())) != null && (used = (gasStack = this.chemTank.extractChemical((long)pumpCapacity, Action.SIMULATE)).getAmount() - toHandler.insertChemical(gasStack, Action.SIMULATE).getAmount()) > 0L) {
                toHandler.insertChemical(this.chemTank.extractChemical(used, Action.EXECUTE), Action.EXECUTE);
            }
        }

        private IChemicalHandler getHandler(Level world, BlockPos pos, Direction facing) {
            return world != null && pos != null ? (IChemicalHandler)world.getCapability(CHEMICAL_HANDLER, pos, (Object)facing) : null;
        }

        @Override
        public int getComparatorOutput() {
            long amount = this.chemTank.getStack().getAmount();
            float fill = (float)amount / (float)this.chemTank.getCapacity();
            return Mth.floor((float)(fill * 14.0f)) + (amount > 0L ? 1 : 0);
        }

        @Override
        public Component getDisplayName() {
            return Component.translatable((String)"info.endertanks.tank.type.mekanism.chemical");
        }
    }
}

