/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers;

import com.mojang.datafixers.DataFixer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.MissingHandlerEvent;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.common.CauldronHelper;
import shetiphian.endertanks.common.EnderFluidHandlerItemStack;
import shetiphian.endertanks.modintegration.handlers.WrapperFluidHandler;

public final class TypeFluid {
    private static final BlockCapability<IFluidHandler, Direction> FLUID_HANDLER = Capabilities.FluidHandler.BLOCK;

    public static void init(RegisterCapabilitiesEvent event) {
        HandlerRegistry.register(HandlerRegistry.DEFAULT_KEY, FLUID_HANDLER.typeClass(), FluidTankHandler::new);
        event.registerBlockEntity(FLUID_HANDLER, (BlockEntityType)Roster.Tiles.ENDERTANK.get(), (tile, side) -> tile.getTankStorage(IFluidHandler.class, (Direction)side));
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, v) -> new EnderFluidHandlerItemStack((ItemStack)stack), new ItemLike[]{(ItemLike)Roster.Items.ENDERTANK.get(), (ItemLike)Roster.Items.ENDERBUCKET.get()});
        NeoForge.EVENT_BUS.addListener(MissingHandlerEvent.class, missingHandlerEvent -> {
            switch (missingHandlerEvent.getProviderId()) {
                case "endertanks:fabric_fluid": 
                case "net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant": 
                case "endertanks:forge_fluid": 
                case "net.minecraftforge.fluids.capability.IFluidHandler": {
                    missingHandlerEvent.setProvider(HandlerRegistry.DEFAULT_KEY.toString());
                }
            }
        });
    }

    public static final class FluidTankHandler
    implements ITankHandler<IFluidHandler> {
        private final FluidTank fluidTank;
        private final IFluidHandler fluidTankInsertOnly;
        private final IFluidHandler fluidTankExtractOnly;

        private FluidTankHandler(final IEnderTankInfo tank) {
            this.fluidTank = new FluidTank(this, tank.getCapacity() * 1000){

                public void setFluid(FluidStack fluid) {
                    if (!FluidStack.isSameFluidSameComponents((FluidStack)this.getFluid(), (FluidStack)fluid)) {
                        super.setFluid(fluid);
                        this.onContentsChanged();
                    }
                }

                public FluidTank setCapacity(int capacity) {
                    if (this.getCapacity() != capacity) {
                        super.setCapacity(capacity);
                        this.onContentsChanged();
                    }
                    return this;
                }

                protected void onContentsChanged() {
                    tank.notifyContentsChange();
                }
            };
            this.fluidTankInsertOnly = new WrapperFluidHandler((IFluidHandler)this.fluidTank, true, false);
            this.fluidTankExtractOnly = new WrapperFluidHandler((IFluidHandler)this.fluidTank, false, true);
        }

        @Override
        public IFluidHandler getTank(StorageAccessMode access) {
            return switch (access) {
                case StorageAccessMode.INSERT_ONLY -> this.fluidTankInsertOnly;
                case StorageAccessMode.EXTRACT_ONLY -> this.fluidTankExtractOnly;
                default -> this.fluidTank;
            };
        }

        @Override
        public void setCapacity(int capacity) {
            this.fluidTank.setCapacity(capacity * 1000);
        }

        @Override
        public CompoundTag portFromOldProvider(CompoundTag nbt, String oldProviderKey) {
            switch (oldProviderKey) {
                case "endertanks:fabric_fluid": 
                case "net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant": {
                    if (!nbt.contains("variant", 10)) break;
                    nbt.putString("id", nbt.getCompound("variant").getString("fluid"));
                    long amount = nbt.getLong("amount");
                    nbt.remove("amount");
                    nbt.putInt("amount", (int)(amount / 81L));
                    break;
                }
            }
            return nbt;
        }

        @Override
        public CompoundTag updateData(CompoundTag nbt, DataFixer dataFixer, int nbtDataVersion, int gameDataVersion) {
            if (nbt.contains("FluidName", 8)) {
                nbt.putString("id", nbt.getString("FluidName"));
            }
            if (nbt.contains("Amount", 3)) {
                nbt.putInt("amount", nbt.getInt("Amount"));
            }
            return nbt;
        }

        @Override
        public void load(CompoundTag nbt, HolderLookup.Provider provider) {
            this.fluidTank.setFluid(FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt));
        }

        @Override
        public CompoundTag save(HolderLookup.Provider provider) {
            FluidStack fluidStack = this.fluidTank.getFluid();
            return fluidStack.isEmpty() ? null : (CompoundTag)fluidStack.save(provider);
        }

        @Override
        public MutableComponent getContentsInfo() {
            FluidStack stack = this.fluidTank.getFluid();
            if (!stack.isEmpty()) {
                return Component.literal((String)" ").append((Component)Component.translatable((String)"info.endertanks.tank.type.fluid")).append(" ").append((Component)Component.translatable((String)stack.getFluidType().getDescriptionId(stack))).append(" [" + (float)stack.getAmount() / 1000.0f + "K/" + this.fluidTank.getCapacity() / 1000 + "K mB]");
            }
            return null;
        }

        @Override
        public void preformPumpAction(Level world, BlockPos pos, Direction facing, BlockPos pullFromPos, BlockPos pushToPos, byte internalPump, RandomSource random) {
            int used;
            FluidStack fluidStack;
            int pumpCapacity;
            if (world.isClientSide() || internalPump == 0) {
                return;
            }
            int n = pumpCapacity = internalPump < 0 ? 250 : internalPump * 1000;
            if (this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
                IFluidHandler fromHandler = this.getHandler(world, pullFromPos, facing);
                if (fromHandler != null) {
                    fluidStack = fromHandler.drain(pumpCapacity, IFluidHandler.FluidAction.SIMULATE);
                    used = this.fluidTank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                    if (used > 0) {
                        this.fluidTank.fill(fromHandler.drain(used, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                } else {
                    BlockState fromState = world.getBlockState(pullFromPos);
                    if (fromState.getBlock() instanceof AbstractCauldronBlock) {
                        CauldronHelper.drainCauldron(fromState, world, pullFromPos, (IFluidHandler)this.fluidTank);
                    }
                }
            }
            if (!this.fluidTank.isEmpty()) {
                IFluidHandler toHandler = this.getHandler(world, pushToPos, facing.getOpposite());
                if (toHandler != null) {
                    fluidStack = this.fluidTank.drain(pumpCapacity, IFluidHandler.FluidAction.SIMULATE);
                    used = toHandler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                    if (used > 0) {
                        toHandler.fill(this.fluidTank.drain(used, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                } else {
                    BlockState toState = world.getBlockState(pushToPos);
                    if (toState.getBlock() instanceof AbstractCauldronBlock) {
                        CauldronHelper.fillCauldron(toState, world, pushToPos, (IFluidHandler)this.fluidTank);
                    }
                }
            }
        }

        private IFluidHandler getHandler(Level world, BlockPos pos, Direction facing) {
            return world != null && pos != null ? (IFluidHandler)world.getCapability(FLUID_HANDLER, pos, (Object)facing) : null;
        }

        @Override
        public int getComparatorOutput() {
            long amount = this.fluidTank.getFluid().getAmount();
            float fill = (float)amount / (float)this.fluidTank.getCapacity();
            return Mth.floor((float)(fill * 14.0f)) + (amount > 0L ? 1 : 0);
        }

        @Override
        public Component getDisplayName() {
            return Component.translatable((String)"info.endertanks.tank.type.fluid");
        }
    }
}

