/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration;

import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import shetiphian.endertanks.Configs;
import shetiphian.endertanks.EnderTanks;

public final class ModIntegration {
    public static final ModIntegration INSTANCE = new ModIntegration();
    private static final String BASE = "shetiphian.endertanks.modintegration.";
    private static final ClassLoader LOADER = EnderTanks.class.getClassLoader();

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        this.load("handlers.TypeFluid", "init", event);
        if (((Boolean)Configs.INTEGRATION.storeMekanismChemicals.get()).booleanValue()) {
            this.load("handlers.mekanism.TypeChemical", "init", event);
        }
    }

    public void init() {
        this.loadAPIs();
        this.sendComms();
    }

    private void loadAPIs() {
    }

    private void load(String name, String method) {
        this.load(name, method, new Object[0]);
    }

    private void load(String name, String method, Object ... args) {
        Class[] classes = new Class[args.length];
        for (int index = 0; index < args.length; ++index) {
            classes[0] = args[0].getClass();
        }
        try {
            LOADER.loadClass(BASE + name).getMethod(method, classes).invoke(null, args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendComms() {
        if (ModList.get().isLoaded("theoneprobe")) {
            this.sendIsolatedComms("theoneprobe.TheOneProbe_Active");
        }
    }

    private void sendIsolatedComms(String name) {
        try {
            LOADER.loadClass(BASE + name).getMethod("sendComms", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

