/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.NameCache;
import shetiphian.core.platform.Services;
import shetiphian.endertanks.client.EventHandlerClient;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;
import shetiphian.endertanks.network.PacketTankInfo;

public class TankInfoHelper {
    private static final Style GOLD = Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GOLD));
    private static final Style GRAY = Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY));
    private static final Style GREEN = Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GREEN));
    private static final Style AQUA = Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.AQUA));
    private static final Style BOLD_RED = Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED)).withBold(Boolean.valueOf(true));
    private static final Component DUMMY = Component.literal((String)"");

    public static void unpackHUDInfo(List<Component> lines, ListTag listNBT, HolderLookup.Provider provider) {
        listNBT.forEach(tag -> lines.add((Component)Component.Serializer.fromJson((String)tag.getAsString(), (HolderLookup.Provider)provider)));
    }

    private static StringTag toTag(Component entry, HolderLookup.Provider provider) {
        return StringTag.valueOf((String)Component.Serializer.toJson((Component)entry, (HolderLookup.Provider)provider));
    }

    public static ListTag packHUDBasic(TileEntityEnderTank tile, HolderLookup.Provider provider) {
        ListTag listNBT = new ListTag();
        listNBT.add((Object)TankInfoHelper.toTag(TankInfoHelper.infoTankOwner(tile.getOwnerName(), true, false), provider));
        listNBT.add((Object)TankInfoHelper.toTag((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"info.endertanks.tank.code")).append((Component)Component.literal((String)(" " + tile.getCode()))), provider));
        return listNBT;
    }

    public static ListTag packHUDContents(TileEntityEnderTank tile, HolderLookup.Provider provider) {
        ListTag listNBT = new ListTag();
        for (Component component : tile.getEnderContainer().getContentsInfo(false)) {
            listNBT.add((Object)TankInfoHelper.toTag(component, provider));
        }
        return listNBT;
    }

    public static ListTag packHUDStatus(TileEntityEnderTank tile, HolderLookup.Provider provider) {
        ListTag listNBT = new ListTag();
        listNBT.add((Object)TankInfoHelper.toTag((Component)TankInfoHelper.infoPump(tile.getPumpInBuckets()).setStyle(GRAY), provider));
        listNBT.add((Object)TankInfoHelper.toTag((Component)Component.literal((String)" ").append(tile.getComparatorTypeDisplayName()).append((Component)Component.literal((String)(" " + tile.getComparatorOutput()))), provider));
        return listNBT;
    }

    public static void sendTankInfo(Player player, String ownerName, String ownerID, String code, boolean sendAll) {
        TankInfoHelper.sendTankInfo(player, TankHelper.getTank(player.level(), ownerID, code).getContentsInfo(!sendAll), Component.literal((String)"").append((Component)Component.translatable((String)("info.endertanks." + (sendAll ? "tank" : "bucket") + ".header")).append(":").setStyle(GOLD)).append(TankInfoHelper.infoTankOwner(ownerName, false, true)));
    }

    public static void sendTankInfo(Player player, TileEntityEnderTank tile) {
        TankInfoHelper.sendTankInfo(player, tile.getEnderContainer().getContentsInfo(false), Component.literal((String)"").append((Component)Component.translatable((String)"info.endertanks.tank.header").append(":").setStyle(GOLD)).append((Component)TankInfoHelper.infoPump(tile.getPumpInBuckets())).append(TankInfoHelper.infoTankOwner(tile.getOwnerName(), false, true)));
    }

    private static void sendTankInfo(Player player, List<MutableComponent> contents, MutableComponent info) {
        if (contents.size() > 1) {
            contents.add(0, info);
            TankInfoHelper.sendInfo(player, contents.toArray(new MutableComponent[0]));
        } else if (contents.size() == 1) {
            TankInfoHelper.sendInfo(player, info.append(" ").append((Component)contents.get(0)));
        }
    }

    public static void sendCapacityInfo(Player player, TileEntityEnderTank tankTile) {
        TankInfoHelper.sendInfo(player, Component.translatable((String)"info.endertanks.tank.capacity").append(" " + TankHelper.getCapacityInBuckets(player.level(), tankTile.getOwnerID(), tankTile.getCode())));
    }

    public static void sendPumpInfo(Player player, TileEntityEnderTank tile) {
        byte pumpInBuckets = tile.getPumpInBuckets();
        if (pumpInBuckets > 0) {
            TankInfoHelper.sendInfo(player, Component.translatable((String)"info.endertanks.tank.pump.upgrade").append(String.format(" %dK mB ", pumpInBuckets * 1000)));
        }
    }

    public static void sendLinkError(Player player, int error) {
        TankInfoHelper.sendInfo(player, Component.translatable((String)("error.endertanks.bucket.nolink" + error)).setStyle(BOLD_RED));
    }

    public static void sendError(Player player, String error) {
        TankInfoHelper.sendInfo(player, Component.translatable((String)("error." + error)).setStyle(BOLD_RED));
    }

    private static MutableComponent infoPump(byte pumpInBuckets) {
        if (pumpInBuckets == 0) {
            return Component.literal((String)"");
        }
        if (pumpInBuckets > 0) {
            return Component.literal((String)String.format(" %dK mB ", pumpInBuckets * 1000)).append((Component)Component.translatable((String)"info.endertanks.tank.pump"));
        }
        return Component.literal((String)" 250mB ").append((Component)Component.translatable((String)"info.endertanks.tank.pump"));
    }

    private static Component infoTankOwner(String owner, boolean displayPublic, boolean comma) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            if (displayPublic) {
                String color = "\u00a76";
                return Component.literal((String)" ").append((Component)Component.literal((String)(color + "[-"))).append((Component)Component.translatable((String)"info.endertanks.tank.public").setStyle(GOLD)).append((Component)Component.literal((String)(color + "-]")));
            }
            return DUMMY;
        }
        boolean isTeam = owner.startsWith("#");
        String color = isTeam ? "\u00a7a" : "\u00a7b";
        return Component.literal((String)(comma ? ", " : " ")).append((Component)Component.literal((String)(color + "[-"))).append((Component)Component.literal((String)owner.substring(isTeam ? 1 : 0)).setStyle(isTeam ? GREEN : AQUA)).append((Component)Component.literal((String)(color + "-]")));
    }

    @Nullable
    public static Component formatTankOwner(String owner) {
        Component component = TankInfoHelper.infoTankOwner(owner, false, false);
        return component != DUMMY ? component : null;
    }

    public static void sendInfo(Player player, MutableComponent ... message) {
        if (player instanceof ServerPlayer) {
            Services.NETWORK.sendToPlayer((CustomPacketPayload)new PacketTankInfo((Component[])message), (ServerPlayer)player);
        } else {
            EventHandlerClient.setDelayedMessage((Component[])message);
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        if (ownerID.startsWith("#")) {
            return "#" + NameCache.getDisplayNameFor((String)ownerID.substring(1));
        }
        return NameCache.getDisplayNameFor((String)ownerID);
    }
}

