/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import java.util.UUID;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import shetiphian.core.common.NbtHelper;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.common.component.BucketMode;
import shetiphian.endertanks.common.component.EnderNetwork;
import shetiphian.endertanks.common.misc.TankInfoHelper;

public class StackHelper {
    public static final String[] BASE_CODES = new String[]{"000", "111", "222", "333", "444", "555", "666", "777", "888", "999", "AAA", "BBB", "CCC", "DDD", "EEE", "FFF"};

    public static ItemStack create(Item item, String code, String ownerID, ItemStack personalItem) {
        ItemStack stack = new ItemStack((ItemLike)item);
        EnderNetwork network = !personalItem.isEmpty() ? new EnderNetwork(StackHelper.formatOwner(ownerID), StackHelper.formatCode(code), personalItem) : new EnderNetwork("all", StackHelper.formatCode(code), ItemStack.EMPTY);
        stack.set((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)network);
        return stack;
    }

    public static ItemStack create(Item item, String code, String ownerID) {
        return StackHelper.setLink(new ItemStack((ItemLike)item), code, ownerID);
    }

    public static ItemStack setLink(ItemStack stack, String code, String ownerID) {
        EnderNetwork network = (EnderNetwork)stack.getOrDefault((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT);
        network = new EnderNetwork(StackHelper.formatOwner(ownerID), StackHelper.formatCode(code), network.stack());
        stack.set((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)network);
        return stack;
    }

    public static void setOwner(ItemStack stack, String ownerID) {
        EnderNetwork network = (EnderNetwork)stack.getOrDefault((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT);
        ownerID = StackHelper.formatOwner(ownerID);
        network = new EnderNetwork(ownerID, network.code(), ownerID.equals("all") ? ItemStack.EMPTY : network.stack());
        stack.set((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)network);
    }

    public static void setCode(ItemStack stack, String code) {
        EnderNetwork network = (EnderNetwork)stack.getOrDefault((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT);
        network = new EnderNetwork(network.id(), StackHelper.formatCode(code), network.stack());
        stack.set((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)network);
    }

    public static String getOwnerID(ItemStack stack) {
        return ((EnderNetwork)stack.getOrDefault((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT)).id();
    }

    public static String getOwnerName(ItemStack stack) {
        return TankInfoHelper.getDisplayNameFromOwnerID(StackHelper.getOwnerID(stack));
    }

    public static String getCode(ItemStack stack) {
        return ((EnderNetwork)stack.getOrDefault((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT)).code();
    }

    public static ItemStack getPersonalItem(ItemStack stack) {
        return ((EnderNetwork)stack.getOrDefault((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT)).stack();
    }

    public static boolean isPublic(ItemStack stack) {
        String ownerID = StackHelper.getOwnerID(stack);
        return Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all");
    }

    public static boolean isPrivate(ItemStack stack) {
        return !StackHelper.isPublic(stack) && !StackHelper.isTeam(stack);
    }

    public static boolean isTeam(ItemStack stack) {
        String ownerID = StackHelper.getOwnerID(stack);
        return !Strings.isNullOrEmpty((String)ownerID) && ownerID.startsWith("#");
    }

    public static String formatCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            return "000";
        }
        if (((String)(code = ((String)code).toUpperCase())).length() != 3) {
            while (((String)code).length() < 3) {
                code = "0" + (String)code;
            }
            code = ((String)code).substring(0, 3);
        }
        if (((String)code).matches("[0-9A-F]{3}")) {
            return code;
        }
        char[] parts = ((String)code).toCharArray();
        for (int index = 0; index < 3; ++index) {
            if (!("" + parts[index]).matches("[^0-9A-F]")) continue;
            parts[index] = 48;
        }
        return "" + parts[0] + parts[1] + parts[2];
    }

    private static String formatOwner(String ownerID) {
        if (!Strings.isNullOrEmpty((String)ownerID) && !ownerID.equalsIgnoreCase("all") && StackHelper.isValidOwnerID(ownerID)) {
            return ownerID;
        }
        return "all";
    }

    public static boolean isValidOwnerID(String ownerID) {
        if (!ownerID.startsWith("#")) {
            try {
                UUID.fromString(ownerID);
            }
            catch (Exception ignored) {
                return false;
            }
        }
        return true;
    }

    public static void cleanOutOldNbt(ItemStack stack) {
        if (!NbtHelper.isOn((ItemStack)stack)) {
            return;
        }
        CompoundTag nbtTag = NbtHelper.getFrom((ItemStack)stack);
        String ownerID = null;
        if (nbtTag.contains("owner", 8)) {
            ownerID = StackHelper.formatOwner(nbtTag.getString("owner"));
            nbtTag.remove("owner");
        }
        String code = null;
        if (nbtTag.contains("code", 8)) {
            code = StackHelper.formatCode(nbtTag.getString("code"));
            nbtTag.remove("code");
        }
        ItemStack personal = null;
        if (nbtTag.contains("personal", 8)) {
            String id = nbtTag.getString("personal");
            try {
                personal = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)id)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            nbtTag.remove("personal");
        }
        if (ownerID != null || code != null || personal != null) {
            EnderNetwork network = (EnderNetwork)stack.getOrDefault((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT);
            network = new EnderNetwork(ownerID != null ? ownerID : network.id(), code != null ? code : network.code(), personal != null ? personal : network.stack());
            stack.set((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)network);
            NbtHelper.setTo((ItemStack)stack, (CompoundTag)nbtTag);
        }
        if (nbtTag.contains("mode", 8)) {
            BucketMode.Enum mode = BucketMode.Enum.byName(nbtTag.getString("mode"));
            stack.set((DataComponentType)Roster.DataComponents.BUCKET_MODE.get(), (Object)new BucketMode(mode));
            nbtTag.remove("mode");
        }
        if (nbtTag.isEmpty()) {
            NbtHelper.removeFrom((ItemStack)stack);
        }
    }
}

