/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ClientHelpers;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.endertanks.Configs;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;

public class ItemBlockEnderTank
extends BlockItem
implements ITabFiller,
IColored {
    public ItemBlockEnderTank(Block block, Item.Properties properties) {
        super(block, properties);
        SideExecutor.runOnClient(() -> () -> {
            ColorHandler.colorize((IColored)this);
            ClientHelpers.addProperty((Item)this, (String)"type", (stack, world, entity, seed) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f));
        });
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        for (String code : StackHelper.BASE_CODES) {
            entries.accept(StackHelper.create((Item)this, code, "all"));
        }
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        StackHelper.cleanOutOldNbt(stack);
    }

    public String getDescriptionId(ItemStack stack) {
        return "block.endertanks.tank." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"info.endertanks.tank.code")).append((Component)Component.literal((String)(" " + StackHelper.getCode(stack)))));
        Component owner = TankInfoHelper.formatTankOwner(StackHelper.getOwnerName(stack));
        if (owner != null) {
            tooltip.add(owner);
        }
    }

    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && data.stack != null) {
            int value = Mth.clamp((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Configs.PROCESSED.colorValues[value];
        }
        return -1;
    }
}

